/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui.admin;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.tree.TreeCellRenderer;
import com.arsdigita.bebop.tree.TreeModel;
import com.arsdigita.bebop.tree.TreeModelBuilder;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.Resource;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.portal.Portlet;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.PortalTab;
import com.arsdigita.portalserver.ui.admin.PortalTreeModelBuilder;
import com.arsdigita.portalserver.ui.admin.UniquePortalURLValidationListener;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class PortalCreateForm {
    public static String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/ui/admin/PortalCreateForm.java#5 $ $Author: dennis $ $DateTime: 2003/08/15 13:46:34 $";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$portalserver$ui$admin$PortalCreateForm == null ? (class$com$arsdigita$portalserver$ui$admin$PortalCreateForm = PortalCreateForm.class$("com.arsdigita.portalserver.ui.admin.PortalCreateForm")) : class$com$arsdigita$portalserver$ui$admin$PortalCreateForm));
    static /* synthetic */ Class class$com$arsdigita$portalserver$ui$admin$PortalCreateForm;

    public static Component create(final RequestLocal parentPortalSite, final RequestLocal portalsiteRL, final ActionListener onFinish) {
        final Form portalCreation = new Form("portalcreation");
        portalCreation.setMethod("post");
        NotEmptyValidationListener notWhiteSpace = new NotEmptyValidationListener();
        UniquePortalURLValidationListener uniqueURL = new UniquePortalURLValidationListener();
        portalCreation.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.parent_workspace")));
        portalCreation.add((Component)new Label(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState ps = e.getPageState();
                Label target = (Label)e.getTarget();
                PortalSite psite = (PortalSite)((Object)parentPortalSite.get(ps));
                if (psite == null) {
                    target.setLabel((String)GlobalizationUtil.globalize("cw.workspace.ui.admin.none").localize());
                    target.setFontWeight("i");
                } else {
                    target.setLabel(psite.getDisplayName());
                }
            }
        }));
        final TextField psName = new TextField((ParameterModel)new StringParameter("psName"));
        psName.getParameterModel().addParameterListener((ParameterListener)notWhiteSpace);
        portalCreation.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.title")));
        portalCreation.add((Component)psName);
        final TextField psLocation = new TextField((ParameterModel)new StringParameter("psNode"));
        psLocation.getParameterModel().addParameterListener((ParameterListener)notWhiteSpace);
        psLocation.getParameterModel().addParameterListener((ParameterListener)uniqueURL);
        psLocation.getParameterModel().addParameterListener(new ParameterListener(){

            public void validate(ParameterEvent e) {
                ParameterData data = e.getParameterData();
                String value = (String)data.getValue();
                char[] chars = value.toCharArray();
                for (int i = 0; i < chars.length; ++i) {
                    if (Character.isLetterOrDigit(chars[i]) || chars[i] == '-' || chars[i] == '_') continue;
                    data.addError("Can only contain letters, numbers, dashes, and underscores");
                    break;
                }
            }
        });
        portalCreation.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.url_fragment")));
        portalCreation.add((Component)psLocation);
        final TextArea psMission = new TextArea((ParameterModel)new StringParameter("psMission"));
        portalCreation.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.mission")));
        portalCreation.add((Component)psMission);
        portalCreation.add((Component)new Submit("done", "Create Portal"));
        portalCreation.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent ev) throws FormProcessException {
                PageState ps = ev.getPageState();
                PortalSite parent = (PortalSite)((Object)parentPortalSite.get(ps));
                String name = (String)psName.getValue(ps);
                String location = (String)psLocation.getValue(ps);
                String mission = (String)psMission.getValue(ps);
                PortalSite psite = PortalSite.createPortalSite(location, name, parent);
                psite.setMission(mission);
                psite.save();
                PortalTab mainTab = PortalTab.createTab("Main", (Resource)psite);
                Portlet portlet = Portlet.createPortlet((String)"com.arsdigita.workspace.ApplicationDirectoryPortlet", (Resource)psite);
                mainTab.addPortlet(portlet, 1);
                portlet = Portlet.createPortlet((String)"com.arsdigita.workspace.WorkspaceNavigatorPortlet", (Resource)psite);
                mainTab.addPortlet(portlet, 1);
                portlet = Portlet.createPortlet((String)"com.arsdigita.workspace.WorkspaceSummaryPortlet", (Resource)psite);
                mainTab.addPortlet(portlet, 1);
                mainTab.setPortalSite(psite);
                mainTab.save();
                psite.addPortalTab(mainTab);
                psite.save();
                portalsiteRL.set(ps, (Object)psite);
                Party party = Kernel.getContext().getParty();
                if (party == null) {
                    throw new IllegalStateException("not logged in");
                }
                psite.addMember(party);
                psite.save();
                PermissionDescriptor perm = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)psite, party);
                PermissionService.grantPermission((PermissionDescriptor)perm);
                onFinish.actionPerformed(new ActionEvent((Component)portalCreation, ps));
            }
        });
        return portalCreation;
    }

    public static Component create(RequestLocal portalsiteRL, final ActionListener onFinish) {
        final SimpleContainer retval = new SimpleContainer();
        final Tree psParent = new Tree((TreeModelBuilder)new PortalTreeModelBuilder());
        psParent.setSelectionModel((SingleSelectionModel)new ParameterSingleSelectionModel((ParameterModel)new BigDecimalParameter("psParent")));
        final Form parentSelection = new Form("parentselection", (Container)new BoxPanel(2));
        parentSelection.setMethod("post");
        RequestLocal parentPortal = new RequestLocal(){

            protected Object initialValue(PageState ps) {
                BigDecimal id = (BigDecimal)psParent.getSelectedKey(ps);
                if (id == null) {
                    return null;
                }
                return PortalSite.retrievePortalSite(id);
            }
        };
        final Component portalCreation = PortalCreateForm.create(parentPortal, portalsiteRL, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                onFinish.actionPerformed(new ActionEvent((Component)retval, ps));
            }
        });
        retval.add((Component)parentSelection);
        retval.add(portalCreation);
        parentSelection.addInitListener(new FormInitListener(){

            public void init(FormSectionEvent e) {
                PageState ps = e.getPageState();
                TreeModel tm = psParent.getTreeModel(ps);
                portalCreation.setVisible(ps, false);
                String key = (String)tm.getRoot(ps).getKey();
                if (psParent.isCollapsed(key, ps)) {
                    psParent.expand((String)tm.getRoot(ps).getKey(), ps);
                }
            }
        });
        parentSelection.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent e) {
                PageState ps = e.getPageState();
                portalCreation.setVisible(ps, true);
                parentSelection.setVisible(ps, false);
            }
        });
        parentSelection.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.select_parent_workspace")));
        psParent.setCellRenderer((TreeCellRenderer)new PortalTreeModelBuilder.DefaultRenderer());
        parentSelection.add((Component)psParent);
        parentSelection.add((Component)new Submit("Continue"));
        return retval;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

