/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui.admin;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.DynamicListWizard;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.ACSObjectCollection;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.Role;
import com.arsdigita.portalserver.RoleCollection;
import com.arsdigita.portalserver.permissions.PartyPermissionEdit;
import com.arsdigita.portalserver.ui.ParticipantBrowsePane;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import com.arsdigita.toolbox.ui.ACSObjectCollectionListModel;
import org.apache.log4j.Category;

public class PeoplePane {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/ui/admin/PeoplePane.java#7 $$Author: ashah $$DateTime: 2003/08/15 15:50:10 $";
    private static final Category s_log = Category.getInstance((String)(class$com$arsdigita$portalserver$ui$admin$PeoplePane == null ? (class$com$arsdigita$portalserver$ui$admin$PeoplePane = PeoplePane.class$("com.arsdigita.portalserver.ui.admin.PeoplePane")) : class$com$arsdigita$portalserver$ui$admin$PeoplePane).getName());
    static /* synthetic */ Class class$com$arsdigita$portalserver$ui$admin$PeoplePane;

    private PeoplePane() {
    }

    public static Component create(Page page, RequestLocal portalsite) {
        SimpleContainer container = new SimpleContainer();
        final DynamicListWizard roles = (DynamicListWizard)PeoplePane.buildRoles(portalsite);
        StringParameter action = new StringParameter("action");
        page.addGlobalStateParam((ParameterModel)action);
        final DynamicListWizard browse = (DynamicListWizard)ParticipantBrowsePane.createForAdmin(portalsite, action, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
            }
        });
        roles.getAddLink().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                browse.reset(e.getPageState());
            }
        });
        roles.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PageState ps = e.getPageState();
                if (roles.getSelectionModel().isSelected(ps)) {
                    browse.reset(e.getPageState());
                }
            }
        });
        browse.getAddLink().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                roles.reset(e.getPageState());
            }
        });
        browse.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PageState ps = e.getPageState();
                if (browse.getSelectionModel().isSelected(ps)) {
                    roles.reset(e.getPageState());
                }
            }
        });
        container.add((Component)browse);
        container.add((Component)roles);
        return container;
    }

    private static Component buildRoles(final RequestLocal portalsiteRL) {
        final ACSObjectSelectionModel selectionModel = new ACSObjectSelectionModel("selectedRole");
        List rList = new List(new ListModelBuilder(){

            public ListModel makeModel(List l, PageState ps) {
                PortalSite psite = (PortalSite)((Object)portalsiteRL.get(ps));
                return new ACSObjectCollectionListModel(this, (ACSObjectCollection)psite.getRoles()){
                    private final /* synthetic */ 6 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object getElement() {
                        RoleCollection rc = (RoleCollection)this.getCollection();
                        if (rc.isSystem()) {
                            return rc.getRoleName() + "*";
                        }
                        return rc.getRoleName();
                    }
                };
            }

            public void lock() {
            }

            public boolean isLocked() {
                return true;
            }
        });
        rList.setSelectionModel((SingleSelectionModel)selectionModel);
        Label emptyView = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.no_roles_defined"));
        emptyView.setFontWeight("i");
        rList.setEmptyView((Component)emptyView);
        DynamicListWizard dlw = new DynamicListWizard("Portal Roles", (Component)rList, (SingleSelectionModel)selectionModel, "Add a role", (Component)new Label(""));
        final RequestLocal role = new RequestLocal(){

            public Object initialValue(PageState ps) {
                return (Role)selectionModel.getSelectedObject(ps);
            }
        };
        dlw.setAddPane(PeoplePane.buildRolesAdd(role, portalsiteRL, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PageState ps = ev.getPageState();
                selectionModel.setSelectedObject(ps, (DomainObject)((Role)((Object)role.get(ps))));
            }
        }));
        dlw.setEditPane(PeoplePane.buildRolesEdit(role, portalsiteRL, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PageState ps = ev.getPageState();
                selectionModel.setSelectedObject(ps, null);
            }
        }));
        return dlw;
    }

    private static Component buildRolesAdd(final RequestLocal roleRL, final RequestLocal portalsiteRL, final ActionListener onAdd) {
        final Form result = new Form("roleAdd");
        result.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.role_name")));
        final TextField roleNameField = new TextField("roleName");
        roleNameField.getParameterModel().addParameterListener((ParameterListener)new NotEmptyValidationListener());
        result.add((Component)roleNameField);
        result.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.assignee_title")));
        final TextField assigneeTitleField = new TextField("assigneeTitle");
        assigneeTitleField.getParameterModel().addParameterListener((ParameterListener)new NotEmptyValidationListener());
        result.add((Component)assigneeTitleField);
        result.add((Component)new Label());
        result.add((Component)new Submit("Add Role"));
        result.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                String roleName = (String)roleNameField.getValue(ps);
                String assigneeTitle = (String)assigneeTitleField.getValue(ps);
                PortalSite psite = (PortalSite)((Object)portalsiteRL.get(ps));
                Role newRole = Role.createRole((PortalSite)((Object)portalsiteRL.get(ps)), roleName, assigneeTitle, "");
                newRole.save();
                PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.READ, (ACSObject)psite, (Party)newRole));
                roleRL.set(ps, (Object)newRole);
                onAdd.actionPerformed(new ActionEvent((Component)result, ps));
            }
        });
        return result;
    }

    private static Component buildRolesEdit(final RequestLocal roleRL, RequestLocal portalsiteRL, final ActionListener onDelete) {
        final BoxPanel result = new BoxPanel();
        result.setWidth("100%");
        GridPanel formPanel = new GridPanel(2);
        Form properties = new Form("roleEdit", (Container)formPanel);
        properties.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.role_name")));
        final TextField roleNameEntry = new TextField("roleName"){

            public boolean isVisible(PageState ps) {
                Role r = (Role)((Object)roleRL.get(ps));
                return r != null && !r.isSystem();
            }
        };
        roleNameEntry.addValidationListener((ParameterListener)new NotEmptyValidationListener());
        final Label roleNameDisplay = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.null_role")){

            public boolean isVisible(PageState ps) {
                Role r = (Role)((Object)roleRL.get(ps));
                return !roleNameEntry.isVisible(ps);
            }
        };
        roleNameDisplay.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent ev) {
                Role r = (Role)((Object)roleRL.get(ev.getPageState()));
                if (r == null) {
                    return;
                }
                Label tgt = (Label)ev.getTarget();
                tgt.setLabel(r.getRoleName());
            }
        });
        SimpleContainer roleNameComposite = new SimpleContainer();
        roleNameComposite.add((Component)roleNameEntry);
        roleNameComposite.add((Component)roleNameDisplay);
        properties.add((Component)roleNameComposite);
        properties.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.assignee_title")));
        final TextField titleEntry = new TextField("assigneeTitle"){

            public boolean isVisible(PageState ps) {
                return roleNameEntry.isVisible(ps);
            }
        };
        titleEntry.addValidationListener((ParameterListener)new NotEmptyValidationListener());
        Label titleDisplay = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.null_assignee_title")){

            public boolean isVisible(PageState ps) {
                return roleNameDisplay.isVisible(ps);
            }
        };
        titleDisplay.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent ev) {
                Role r = (Role)((Object)roleRL.get(ev.getPageState()));
                if (r == null) {
                    return;
                }
                Label tgt = (Label)ev.getTarget();
                tgt.setLabel(r.getAssigneeTitle());
            }
        });
        SimpleContainer titleComposite = new SimpleContainer();
        titleComposite.add((Component)titleEntry);
        titleComposite.add((Component)titleDisplay);
        properties.add((Component)titleComposite);
        properties.add((Component)new Label());
        properties.add((Component)new Submit("Update Role"){

            public boolean isVisible(PageState ps) {
                return roleNameEntry.isVisible(ps);
            }
        });
        properties.addInitListener(new FormInitListener(){

            public void init(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                Role role = (Role)((Object)roleRL.get(ps));
                roleNameEntry.setValue(ps, (Object)role.getRoleName());
            }
        });
        properties.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent ev) throws FormProcessException {
                PageState ps = ev.getPageState();
                Role role = (Role)((Object)roleRL.get(ps));
                if (!role.isSystem()) {
                    String newRoleName = (String)roleNameEntry.getValue(ps);
                    String newTitle = (String)titleEntry.getValue(ps);
                    role.setRoleName(newRoleName);
                    role.setAssigneeTitle(newTitle);
                    role.save();
                }
            }
        });
        result.add((Component)properties);
        ActionLink deleteRole = new ActionLink((String)GlobalizationUtil.globalize("cw.workspace.ui.admin.delete_role").localize()){

            public boolean isVisible(PageState ps) {
                Role r = (Role)((Object)roleRL.get(ps));
                return !r.isSystem();
            }
        };
        deleteRole.setConfirmation("Really delete portal role?");
        deleteRole.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                Role r = (Role)((Object)roleRL.get(ps));
                r.getPortalSite().assertPrivilege(PrivilegeDescriptor.ADMIN);
                KernelExcursion ex = new KernelExcursion(this, r){
                    private final /* synthetic */ Role val$r;
                    private final /* synthetic */ 22 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$r = val$r;
                    }

                    protected void excurse() {
                        this.setEffectiveParty(Kernel.getSystemParty());
                        this.val$r.delete();
                    }
                };
                ex.run();
                onDelete.actionPerformed(new ActionEvent((Component)result, ps));
            }
        });
        result.add((Component)deleteRole);
        PartyPermissionEdit permWidget = new PartyPermissionEdit("Privileges", portalsiteRL, roleRL);
        result.add((Component)permWidget);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ParticipantsModel
    implements ListModel {
        private PartyCollection m_parties;

        public ParticipantsModel(PortalSite psite) {
            this.m_parties = psite.getParticipants();
        }

        public boolean next() {
            return this.m_parties.next();
        }

        public String getKey() {
            return this.m_parties.getID().toString();
        }

        public Object getElement() {
            return this.m_parties.getDisplayName();
        }
    }
}

