/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.test;

import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.Resource;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserFactory;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.portal.Portlet;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.PortalSiteCollection;
import com.arsdigita.portalserver.PortalTab;
import com.arsdigita.portalserver.Role;
import com.arsdigita.web.Application;
import org.apache.log4j.Logger;

public class TestPortalSetup {
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$portalserver$test$TestPortalSetup == null ? (class$com$arsdigita$portalserver$test$TestPortalSetup = TestPortalSetup.class$("com.arsdigita.portalserver.test.TestPortalSetup")) : class$com$arsdigita$portalserver$test$TestPortalSetup));
    private PortalSite m_portalsite;
    private Party m_member;
    private Party m_editor;
    private Party m_manager;
    private Role m_members;
    private Role m_editors;
    private Role m_managers;
    static /* synthetic */ Class class$com$arsdigita$portalserver$test$TestPortalSetup;

    public void setupPortal() {
        s_log.warn((Object)"Calling setupPortal");
        if (this.portalDoesNotExist()) {
            s_log.warn((Object)"Creating test portal titled: test");
            this.setupDefaultPortal();
            this.setupDefaultRoles();
            this.setupDefaultUsers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean portalDoesNotExist() {
        s_log.warn((Object)"Checking for portals!");
        PortalSiteCollection psites = PortalSite.retrieveAllPortalSites();
        boolean doesNotExist = true;
        int portalCount = 0;
        try {
            s_log.warn((Object)"Starting loop!");
            while (psites.next() && doesNotExist) {
                String title = psites.getTitle();
                s_log.warn((Object)("Portal: " + title));
                doesNotExist = !title.equals("test");
                ++portalCount;
            }
        }
        finally {
            psites.close();
        }
        s_log.warn((Object)("Portal count: " + portalCount));
        return doesNotExist;
    }

    private Role createRole(PortalSite portalsite, String roleName, String assigneeTitle, String description) {
        Role newRole = this.createRole(portalsite, roleName, assigneeTitle, description, PrivilegeDescriptor.READ);
        return newRole;
    }

    private Role createRole(PortalSite portalsite, String roleName, String assigneeTitle, String description, PrivilegeDescriptor privilege) {
        Role newRole = Role.createRole(portalsite, roleName, assigneeTitle, description);
        newRole.save();
        PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.CREATE, (ACSObject)portalsite, (Party)newRole));
        PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(privilege, (ACSObject)portalsite, (Party)newRole));
        return newRole;
    }

    private void setupDefaultPortal() {
        this.m_portalsite = PortalSite.createPortalSite("test", "test", null);
        this.m_portalsite.save();
        PortalTab mainTab = PortalTab.createTab("Main");
        Portlet portlet = Portlet.createPortlet((String)"com.arsdigita.workspace.ApplicationDirectoryPortlet", (Resource)this.m_portalsite);
        mainTab.addPortlet(portlet, 1);
        portlet = Portlet.createPortlet((String)"com.arsdigita.workspace.WorkspaceNavigatorPortlet", (Resource)this.m_portalsite);
        mainTab.addPortlet(portlet, 1);
        portlet = Portlet.createPortlet((String)"com.arsdigita.workspace.WorkspaceSummaryPortlet", (Resource)this.m_portalsite);
        mainTab.addPortlet(portlet, 1);
        mainTab.setPortalSite(this.m_portalsite);
        mainTab.save();
        this.m_portalsite.addPortalTab(mainTab);
        this.m_portalsite.save();
    }

    private Application addApplication(String applicationObjectType, String urlName, String title) {
        Application app = Application.createApplication((String)applicationObjectType, (String)urlName, (String)title, (Application)this.m_portalsite);
        app.save();
        return app;
    }

    private void setupDefaultUsers() {
        this.m_member = this.createUser("Joe", "User");
        this.m_editor = this.createUser("Joe", "Editor");
        this.m_manager = this.createUser("Joe", "Manager");
        this.m_portalsite.addParticipant(this.m_member);
        this.m_portalsite.addParticipant(this.m_editor);
        this.m_portalsite.addParticipant(this.m_manager);
        this.m_portalsite.save();
        this.m_members.addMemberOrSubgroup(this.m_member);
        this.m_members.save();
        this.m_editors.addMemberOrSubgroup(this.m_editor);
        this.m_editors.save();
        this.m_managers.addMemberOrSubgroup(this.m_manager);
        this.m_managers.save();
    }

    private User createUser(String firstName, String lastName) {
        String firstLast = firstName.trim().toLowerCase() + lastName.trim().toLowerCase();
        EmailAddress email = new EmailAddress(firstLast + "@" + "redhat.com");
        User user = UserFactory.newUser((EmailAddress)email, (String)firstName, (String)lastName, (String)firstLast, (String)firstLast, (String)firstLast, null, null, null);
        user.save();
        return user;
    }

    private void setupDefaultRoles() {
        this.m_members = this.m_portalsite.getMemberRole();
        this.m_editors = this.createRole(this.m_portalsite, "Editors", "Editor", "", PrivilegeDescriptor.EDIT);
        this.m_managers = this.createRole(this.m_portalsite, "Managers", "Manager", "", PrivilegeDescriptor.ADMIN);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

