/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.personal;

import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageDispatcher;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.dispatcher.Dispatcher;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Resource;
import com.arsdigita.kernel.ResourceTypeConfig;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.kernel.User;
import com.arsdigita.portalserver.personal.PersonalPortal;
import com.arsdigita.sitenode.SiteNodeRequestContext;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Application;
import java.io.IOException;
import java.math.BigDecimal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Category;

public class PersonalPortalCreatorDispatcher
implements Dispatcher {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/personal/PersonalPortalCreatorDispatcher.java#4 $$Author: dennis $$DateTime: 2003/08/15 13:46:34 $";
    private static Category s_log = Category.getInstance((Class)(class$com$arsdigita$portalserver$personal$PersonalPortalCreatorDispatcher == null ? (class$com$arsdigita$portalserver$personal$PersonalPortalCreatorDispatcher = PersonalPortalCreatorDispatcher.class$("com.arsdigita.portalserver.personal.PersonalPortalCreatorDispatcher")) : class$com$arsdigita$portalserver$personal$PersonalPortalCreatorDispatcher));
    private Dispatcher m_introDispatcher = null;
    static /* synthetic */ Class class$com$arsdigita$portalserver$personal$PersonalPortalCreatorDispatcher;

    private BigDecimal scanUserID(SiteNodeRequestContext snrc) {
        String url = snrc.getRemainingURLPart();
        int delimIndex = url.indexOf("/");
        try {
            if (delimIndex == -1) {
                return new BigDecimal(url);
            }
            return new BigDecimal(url.substring(0, delimIndex));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        catch (IndexOutOfBoundsException iobe) {
            return null;
        }
    }

    private Application getApplication(SiteNodeRequestContext snrc) {
        SiteNode siteNode = snrc.getSiteNode();
        Application parent = Application.retrieveApplicationForSiteNode((SiteNode)siteNode);
        Assert.assertNotNull((Object)parent, (String)"parent");
        return parent;
    }

    private User getUser(BigDecimal userID) {
        User user = null;
        try {
            user = User.retrieve((BigDecimal)userID);
        }
        catch (DataObjectNotFoundException nfe) {
            s_log.error((Object)("Failed to retrieve user " + userID + "."), (Throwable)new IllegalStateException());
        }
        Assert.assertNotNull((Object)user, (String)"user");
        return user;
    }

    private void configurePortal(PersonalPortal portal) {
        ResourceTypeConfig config = portal.getApplicationType().getConfig();
        Assert.assertNotNull((Object)config, (String)"config");
        config.configureResource((Resource)portal);
    }

    private Page buildIntroPage() {
        Page page = new Page("", (Container)new SimpleContainer());
        page.lock();
        return page;
    }

    public void dispatch(HttpServletRequest request, HttpServletResponse response, RequestContext context) throws IOException, ServletException {
        Assert.assertTrue((boolean)(context instanceof SiteNodeRequestContext));
        SiteNodeRequestContext snrc = (SiteNodeRequestContext)context;
        final Application parent = this.getApplication(snrc);
        BigDecimal userID = this.scanUserID(snrc);
        if (userID == null) {
            s_log.warn((Object)"Failed to read a user ID from a personal-portal link.");
        } else {
            final User user = this.getUser(userID);
            PersonalPortal portal = PersonalPortal.retrievePersonalPortal(user);
            if (portal == null) {
                KernelExcursion rootExcursion = new KernelExcursion(){

                    protected void excurse() {
                        this.setParty(Kernel.getSystemParty());
                        PersonalPortal ps = PersonalPortal.createPersonalPortal(user, parent);
                        Assert.assertNotNull((Object)((Object)ps), (String)"portal");
                        PersonalPortalCreatorDispatcher.this.configurePortal(ps);
                        ps.save();
                    }
                };
                rootExcursion.run();
            } else {
                s_log.error((Object)"PersonalPortalCreator invoked when the portalsite exists already.", (Throwable)new IllegalStateException());
            }
            if (this.m_introDispatcher == null) {
                this.m_introDispatcher = new PageDispatcher(this.buildIntroPage());
            }
            Assert.assertNotNull((Object)this.m_introDispatcher, (String)"m_introDispatcher");
            DispatcherHelper.sendRedirect((HttpServletRequest)request, (HttpServletResponse)response, (String)snrc.getOriginalURL());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

