/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.personal;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Application;

public class PersonalPortal
extends PortalSite {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/personal/PersonalPortal.java#4 $$Author: dennis $$DateTime: 2003/08/15 13:46:34 $";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.workspace.personal.PersonalWorkspace";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    protected PersonalPortal(DataObject dataObject) {
        super(dataObject);
    }

    public static PersonalPortal createPersonalPortal(User user, Application parent) {
        Assert.assertNotNull((Object)user, (String)"user");
        PersonalPortal portal = (PersonalPortal)Application.createApplication((String)BASE_DATA_OBJECT_TYPE, (String)user.getID().toString(), (String)"Personal Portal", (Application)parent);
        portal.setOwningUser(user);
        return portal;
    }

    public static PersonalPortal createPersonalPortal(User user) {
        Application parent = Application.retrieveApplicationForPath((String)"/personal-portal/");
        Assert.assertNotNull((Object)parent, (String)"parent");
        return PersonalPortal.createPersonalPortal(user, parent);
    }

    public static PersonalPortal retrievePersonalPortal(User user) {
        DataCollection portals = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        portals.addEqualsFilter("user.id", (Object)user.getID());
        PersonalPortal portal = null;
        if (portals.next()) {
            portal = (PersonalPortal)Application.retrieveApplication((DataObject)portals.getDataObject());
        }
        portals.close();
        return portal;
    }

    private void setOwningUser(User user) {
        Assert.assertNotNull((Object)user, (String)"user");
        this.setAssociation("user", (DomainObject)user);
    }

    public User getOwningUser() {
        DataObject dataObject = (DataObject)this.get("user");
        Assert.assertNotNull((Object)dataObject, (String)"dataObject");
        return User.retrieve((DataObject)dataObject);
    }
}

