/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.DimensionalNavbar;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.portalserver.ApplicationPage;
import com.arsdigita.portalserver.LoggedInLinkWrapper;
import com.arsdigita.portalserver.PortalPage;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.personal.PersonalPortal;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Application;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ToolPage
extends PortalPage {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/ToolPage.java#4 $$Author: dennis $$DateTime: 2003/08/15 13:46:34 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$portalserver$ToolPage == null ? (class$com$arsdigita$portalserver$ToolPage = ToolPage.class$("com.arsdigita.portalserver.ToolPage")) : class$com$arsdigita$portalserver$ToolPage));
    private String m_view;
    private Link m_viewLink;
    static /* synthetic */ Class class$com$arsdigita$portalserver$ToolPage;

    public ToolPage() {
        this(null);
    }

    public ToolPage(String view) {
        this.m_view = view;
    }

    protected void buildContextBar() {
        DimensionalNavbar navbar = new DimensionalNavbar();
        navbar.setClassAttr("portalNavbar");
        navbar.add((Component)new LoggedInLinkWrapper(new PortalPage.PersonalPortalLinkPrinter()));
        Link current = new Link(new PortalPage.CurrentPortalLinkPrinter()){

            public boolean isVisible(PageState state) {
                PortalSite psite = PortalSite.getCurrentPortalSite(state.getRequest());
                return !(psite instanceof PersonalPortal);
            }
        };
        navbar.add((Component)current);
        if (this.m_view != null && this.m_view.equals("admin")) {
            navbar.add((Component)new Link(new ApplicationPage.CurrentApplicationLinkPrinter()){

                public boolean isVisible(PageState ps) {
                    return ToolPage.this.userIsAdmin(ps);
                }
            });
            navbar.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.administration")){

                public boolean isVisible(PageState ps) {
                    return ToolPage.this.userIsAdmin(ps);
                }
            });
        } else {
            navbar.add((Component)new Label((PrintListener)new ApplicationPage.CurrentApplicationLabelPrinter()));
        }
        this.getHeader().add((Component)navbar);
    }

    protected void buildTitle() {
        if (this.m_view != null && this.m_view.equals("admin")) {
            class ApplicationAdminLabelPrinter
            implements PrintListener {
                ApplicationAdminLabelPrinter() {
                }

                public void prepare(PrintEvent e) {
                    Label targetLabel = (Label)e.getTarget();
                    PageState pageState = e.getPageState();
                    Application application = Application.getCurrentApplication((HttpServletRequest)pageState.getRequest());
                    Assert.assertNotNull((Object)application, (String)"application");
                    targetLabel.setLabel(application.getTitle() + " Administration");
                }
            }
            this.setTitle(new Label((PrintListener)new ApplicationAdminLabelPrinter()));
        } else {
            this.setTitle(new Label((PrintListener)new ApplicationPage.CurrentApplicationLabelPrinter()));
        }
    }

    protected void buildHeader(Container header) {
        if (this.m_view != null) {
            if (this.m_view.equals("user")) {
                this.m_viewLink = new Link("Administration view", "./admin/index.jsp"){

                    public boolean isVisible(PageState ps) {
                        return ToolPage.this.userIsAdmin(ps);
                    }
                };
            } else if (this.m_view.equals("admin")) {
                this.m_viewLink = new Link((Component)new Label(GlobalizationUtil.globalize("cw.workspace.user_view")), "../index.jsp");
            }
        }
        if (this.m_viewLink != null) {
            this.m_viewLink.setClassAttr("portalControl");
            header.add((Component)this.m_viewLink);
        }
    }

    private boolean userIsAdmin(PageState ps) {
        PermissionDescriptor permDescriptor = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)Application.getCurrentApplication((HttpServletRequest)ps.getRequest()), Kernel.getContext().getParty());
        return PermissionService.checkPermission((PermissionDescriptor)permDescriptor);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

