/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.ListPanel;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.portal.apportlet.AppPortlet;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import com.arsdigita.web.URL;
import com.arsdigita.xml.Element;

public class PortalSummaryPortlet
extends AppPortlet {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/PortalSummaryPortlet.java#7 $ by $Author: dennis $, $DateTime: 2003/08/15 13:46:34 $";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.workspace.WorkspaceSummaryPortlet";
    private static final int MAX_PARTICIPANTS_FOR_LISTING = 15;

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public PortalSummaryPortlet(DataObject dataObject) {
        super(dataObject);
    }

    protected AbstractPortletRenderer doGetPortletRenderer() {
        return new PortalSummaryPortletRenderer(this);
    }

    public String getZoomURL() {
        return URL.getDispatcherPath() + this.getParentApplication().getPrimaryURL() + "participants/";
    }

    private static class PortalSummaryPortletRenderer
    extends AbstractPortletRenderer {
        private PortalSummaryPortlet m_portlet;

        public PortalSummaryPortletRenderer(PortalSummaryPortlet portlet) {
            this.m_portlet = portlet;
        }

        protected void generateBodyXML(PageState ps, Element parent) {
            PortalSite currentPortal = (PortalSite)this.m_portlet.getParentApplication();
            if (currentPortal == null) {
                return;
            }
            SegmentedPanel main = new SegmentedPanel();
            String mission = currentPortal.getMission();
            if (mission != null) {
                main.addSegment((Component)new Label(GlobalizationUtil.globalize("cw.workspace.mission")), (Component)new Label(mission, false));
            }
            PartyCollection pc = currentPortal.getParticipants();
            ListPanel participants = new ListPanel(false);
            long participantCount = pc.size();
            if (participantCount > 15L) {
                DataQuery dq = SessionManager.getSession().retrieveQuery("com.arsdigita.workspace.RolesWithCounts");
                dq.setParameter("workspaceID", (Object)currentPortal.getID());
                while (dq.next()) {
                    participants.add((Component)new Label(dq.get("roleCount") + " " + dq.get("roleName")));
                }
                participants.add((Component)new Label(participantCount + " " + " Total participants"));
            } else {
                while (pc.next()) {
                    participants.add((Component)new Label(pc.getDisplayName()));
                }
            }
            Link searchLink = new Link((Component)new Label(GlobalizationUtil.globalize("cw.workspace.search_participants")), "participants/");
            searchLink.addURLVars("action", "search");
            participants.add((Component)searchLink);
            main.addSegment((Component)new Label(GlobalizationUtil.globalize("cw.workspace.participants")), (Component)participants);
            main.generateXML(ps, parent);
        }
    }
}

