/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui.admin;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.CompoundComponent;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormValidationException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.Resource;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.ui.ResourceConfigFormSection;
import com.arsdigita.portal.Portlet;
import com.arsdigita.portal.PortletType;
import com.arsdigita.portalserver.PortalPage;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.PortalTab;
import com.arsdigita.portalserver.ui.admin.ApplicationCreateComponent;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationCollection;
import com.arsdigita.web.ApplicationType;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

class PortletAddForm
extends CompoundComponent {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$portalserver$ui$admin$PortletAddForm == null ? (class$com$arsdigita$portalserver$ui$admin$PortletAddForm = PortletAddForm.class$("com.arsdigita.portalserver.ui.admin.PortletAddForm")) : class$com$arsdigita$portalserver$ui$admin$PortletAddForm));
    private static final String LEFT_COLUMN = "left";
    private static final String RIGHT_COLUMN = "right";
    private PortalPage m_portalPage;
    private RequestLocal m_portalsiteRL;
    private RequestLocal m_portalIDRL;
    private RequestLocal m_portletTypeRL;
    private RequestLocal m_appTypeRL = new RequestLocal(){

        protected Object initialValue(PageState ps) {
            PortletType portletType = (PortletType)PortletAddForm.this.m_portletTypeRL.get(ps);
            if (portletType == null) {
                return null;
            }
            return portletType.getProviderApplicationType();
        }
    };
    private final BigDecimalParameter m_parentAppParam = new BigDecimalParameter("appID");
    private RequestLocal m_parentAppRL = new RequestLocal(){

        protected Object initialValue(PageState ps) {
            BigDecimal id = (BigDecimal)ps.getValue((ParameterModel)PortletAddForm.this.m_parentAppParam);
            if (id == null) {
                return null;
            }
            return Application.retrieveApplication((BigDecimal)id);
        }
    };
    private final StringParameter m_columnParam = new StringParameter("colID");
    private Form m_portletTypeForm;
    private Form m_appSelect;
    private Form m_newExistingSelect;
    private Form m_existingSelect;
    private ApplicationCreateComponent m_appCreate;
    private ApplicationCreateComponent m_portletCreate;
    static /* synthetic */ Class class$com$arsdigita$portalserver$ui$admin$PortletAddForm;

    public PortletAddForm(RequestLocal portalsiteRL, RequestLocal portalIDRL, RequestLocal portletTypeRL) {
        this.m_portalsiteRL = portalsiteRL;
        this.m_portalIDRL = portalIDRL;
        this.m_portletTypeRL = portletTypeRL;
        final RequestLocal createNewRL = new RequestLocal();
        this.m_newExistingSelect = PortletAddForm.buildNewExistingSelect(this.m_appTypeRL, this.m_portalsiteRL, createNewRL, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PageState ps = ev.getPageState();
                if (createNewRL.get(ps).equals(Boolean.TRUE)) {
                    PortletAddForm.this.m_portalPage.goModal(ps, (Component)PortletAddForm.this.m_appCreate);
                } else {
                    PortletAddForm.this.m_portalPage.goModal(ps, (Component)PortletAddForm.this.m_appSelect);
                }
            }
        }, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PageState ps = ev.getPageState();
                PortletAddForm.this.fireCompletionEvent(ps);
            }
        });
        this.add((Component)this.m_newExistingSelect);
        final RequestLocal makeLocalRL = new RequestLocal();
        this.m_existingSelect = PortletAddForm.buildExistingSelect(this.m_appTypeRL, this.m_portalsiteRL, makeLocalRL, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PageState ps = ev.getPageState();
                if (makeLocalRL.get(ps).equals(Boolean.TRUE)) {
                    PortletType ptype = (PortletType)PortletAddForm.this.m_portletTypeRL.get(ps);
                    PortalSite psite = (PortalSite)((Object)PortletAddForm.this.m_portalsiteRL.get(ps));
                    ApplicationCollection apps = psite.getFullPagePortalSiteApplications();
                    ApplicationType appType = (ApplicationType)PortletAddForm.this.m_appTypeRL.get(ps);
                    Application app = null;
                    boolean wasFound = false;
                    while (apps.next()) {
                        app = apps.getApplication();
                        ApplicationType atp = app.getApplicationType();
                        if (!atp.getID().equals(appType.getID())) continue;
                        apps.close();
                        wasFound = true;
                        break;
                    }
                    if (wasFound) {
                        Portlet portlet = Portlet.createPortlet((PortletType)ptype, (Resource)app);
                        PortletAddForm.this.addToTab(ps, portlet);
                        PortletAddForm.this.fireCompletionEvent(ps);
                    }
                } else {
                    PortletAddForm.this.m_portalPage.goModal(ps, (Component)PortletAddForm.this.m_appSelect);
                }
            }
        }, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PageState ps = ev.getPageState();
                PortletAddForm.this.fireCompletionEvent(ps);
            }
        });
        this.add((Component)this.m_existingSelect);
        final RequestLocal selectedAppRL = new RequestLocal();
        this.m_appSelect = PortletAddForm.buildAppSelect(this.m_appTypeRL, this.m_portalsiteRL, selectedAppRL, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PageState ps = ev.getPageState();
                Application app = (Application)selectedAppRL.get(ps);
                if (app == null) {
                    PortletAddForm.this.m_portalPage.goModal(ps, (Component)PortletAddForm.this.m_appCreate);
                } else {
                    PortletType ptype = (PortletType)PortletAddForm.this.m_portletTypeRL.get(ps);
                    if (PortletAddForm.this.m_portletCreate.canCreate((ResourceType)ptype)) {
                        ps.setValue((ParameterModel)PortletAddForm.this.m_parentAppParam, (Object)app.getID());
                        PortletAddForm.this.m_portalPage.goModal(ps, (Component)PortletAddForm.this.m_portletCreate);
                    } else {
                        Portlet portlet = Portlet.createPortlet((PortletType)ptype, (Resource)app);
                        PortletAddForm.this.addToTab(ps, portlet);
                        PortletAddForm.this.fireCompletionEvent(ps);
                    }
                }
            }
        }, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PageState ps = ev.getPageState();
                PortletAddForm.this.m_portalPage.goModal(ps, (Component)PortletAddForm.this.m_newExistingSelect);
            }
        }, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PageState ps = ev.getPageState();
                PortletAddForm.this.fireCompletionEvent(ps);
            }
        });
        this.add((Component)this.m_appSelect);
        final RequestLocal createdAppRL = new RequestLocal();
        this.m_appCreate = PortletAddForm.buildAppCreate(this.m_appTypeRL, this.m_portalsiteRL, createdAppRL, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PageState ps = ev.getPageState();
                Application app = (Application)createdAppRL.get(ps);
                app.save();
                PortletType ptype = (PortletType)PortletAddForm.this.m_portletTypeRL.get(ps);
                if (PortletAddForm.this.m_portletCreate.canCreate((ResourceType)ptype)) {
                    ps.setValue((ParameterModel)PortletAddForm.this.m_parentAppParam, (Object)app.getID());
                    PortletAddForm.this.m_portalPage.goModal(ps, (Component)PortletAddForm.this.m_portletCreate);
                } else {
                    Portlet portlet = Portlet.createPortlet((PortletType)ptype, (Resource)app);
                    PortletAddForm.this.addToTab(ps, portlet);
                    PortletAddForm.this.fireCompletionEvent(ps);
                }
            }
        }, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PageState ps = ev.getPageState();
                PortletAddForm.this.m_portalPage.goModal(ps, (Component)PortletAddForm.this.m_newExistingSelect);
            }
        }, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PageState ps = ev.getPageState();
                PortletAddForm.this.fireCompletionEvent(ps);
            }
        });
        this.add((Component)this.m_appCreate);
        final RequestLocal portletRL = new RequestLocal();
        this.m_portletCreate = PortletAddForm.buildPortletCreate(this.m_portletTypeRL, this.m_parentAppRL, portletRL, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PageState ps = ev.getPageState();
                Portlet portlet = (Portlet)portletRL.get(ps);
                PortletAddForm.this.addToTab(ps, portlet);
                PortletAddForm.this.fireCompletionEvent(ps);
            }
        }, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PageState ps = ev.getPageState();
                PortletAddForm.this.fireCompletionEvent(ps);
            }
        });
        this.add((Component)this.m_portletCreate);
    }

    protected void fireCompletionEvent(PageState ps) {
        ps.reset((Component)this);
        this.m_portalPage.goUnmodal(ps);
        super.fireCompletionEvent(ps);
    }

    private static final ApplicationCollection getApplicationChoices(ApplicationType type) {
        ApplicationCollection ac = Application.retrieveAllApplications();
        ac.filterToApplicationType(type.getApplicationObjectType());
        ac.filterToHasFullPageView();
        ac.filterToWorkspaceApplications();
        return ac;
    }

    public void activate(PageState ps) {
        ApplicationType appType = (ApplicationType)this.m_appTypeRL.get(ps);
        PortalSite psite = (PortalSite)((Object)this.m_portalsiteRL.get(ps));
        if (appType == null) {
            PortletType ptype = (PortletType)this.m_portletTypeRL.get(ps);
            ApplicationType atp = ptype.getProviderApplicationType();
            if (atp != null && atp.isSingleton()) {
                ApplicationCollection apps = psite.getFullPagePortalSiteApplications();
                boolean wasFound = false;
                while (apps.next()) {
                    ApplicationType applicationType = apps.getApplication().getApplicationType();
                    if (!applicationType.getID().equals(atp.getID())) continue;
                    wasFound = true;
                    Portlet portlet = Portlet.createPortlet((PortletType)ptype, (Resource)apps.getApplication());
                    this.addToTab(ps, portlet);
                    this.fireCompletionEvent(ps);
                    break;
                }
                apps.close();
                if (!wasFound) {
                    Application newApp = Application.createApplication((ApplicationType)atp, (String)atp.getID().toString(), (String)atp.getTitle(), (Application)psite);
                    Portlet portlet = Portlet.createPortlet((PortletType)ptype, (Resource)newApp);
                    this.addToTab(ps, portlet);
                    this.fireCompletionEvent(ps);
                }
            } else if (this.m_portletCreate.canCreate((ResourceType)ptype)) {
                ps.setValue((ParameterModel)this.m_parentAppParam, (Object)psite.getID());
                this.m_portalPage.goModal(ps, (Component)this.m_portletCreate);
            } else {
                Portlet portlet = Portlet.createPortlet((PortletType)ptype, (Resource)psite);
                this.addToTab(ps, portlet);
                this.fireCompletionEvent(ps);
            }
            return;
        }
        if (appType.isSingleton()) {
            if (psite.isAppTypeInPortalSite(appType)) {
                this.m_portalPage.goModal(ps, (Component)this.m_existingSelect);
            } else {
                this.m_portalPage.goModal(ps, (Component)this.m_appCreate);
            }
        } else {
            ApplicationCollection ac = PortletAddForm.getApplicationChoices(appType);
            if (ac.size() == 0L) {
                this.m_portalPage.goModal(ps, (Component)this.m_appCreate);
            } else {
                this.m_portalPage.goModal(ps, (Component)this.m_newExistingSelect);
            }
        }
    }

    public void register(Page p) {
        super.register(p);
        this.m_portalPage = (PortalPage)p;
        p.addComponentStateParam((Component)this, (ParameterModel)this.m_columnParam);
        p.addComponentStateParam((Component)this, (ParameterModel)this.m_parentAppParam);
    }

    private static Form buildNewExistingSelect(final RequestLocal appTypeRL, RequestLocal portalsiteRL, final RequestLocal createNew, final ActionListener onNext, final ActionListener onCancel) {
        final Form f = new Form("newexist", (Container)new BoxPanel(2)){

            public void generateXML(PageState ps, Element parent) {
                this.getFormData(ps);
                super.generateXML(ps, parent);
            }
        };
        final Label info = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.choose_new_or_existing"));
        f.add((Component)info);
        final RadioGroup rg = new RadioGroup("select");
        rg.setLayout(2);
        final Label newLabel = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.create_new"), false);
        final Label existingLabel = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.pick_existing"), false);
        rg.addOption(new Option("create", (Component)newLabel));
        rg.addOption(new Option("choose", (Component)existingLabel));
        rg.setOptionSelected("create");
        f.add((Component)rg);
        BoxPanel buttons = new BoxPanel(1);
        Submit next = new Submit("Next >>");
        final Submit cancel = new Submit("Cancel");
        buttons.add((Component)next);
        buttons.add((Component)cancel);
        f.add((Component)buttons);
        f.addInitListener(new FormInitListener(){

            public void init(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                ApplicationType type = (ApplicationType)appTypeRL.get(ps);
                String title = type.getTitle();
                title = title.toLowerCase();
                info.setLabel("You can choose which " + title + " to display in the new portlet.", ps);
                newLabel.setLabel("I want to <b>create a new " + title + "</b> to display in the portlet.", ps);
                existingLabel.setLabel("I want to <b>choose an existing " + title + "</b> to display in the portlet.", ps);
            }
        });
        f.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                if (cancel.isSelected(ps)) {
                    onCancel.actionPerformed(new ActionEvent((Component)f, ps));
                    return;
                }
                String value = (String)rg.getValue(ps);
                if ("create".equals(value)) {
                    createNew.set(ps, (Object)Boolean.TRUE);
                } else if ("choose".equals(value)) {
                    createNew.set(ps, (Object)Boolean.FALSE);
                } else {
                    throw new IllegalStateException("invalid selection");
                }
                onNext.actionPerformed(new ActionEvent((Component)f, ps));
            }
        });
        f.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                if (cancel.isSelected(ps)) {
                    onCancel.actionPerformed(new ActionEvent((Component)f, ps));
                    return;
                }
            }
        });
        return f;
    }

    private static Form buildExistingSelect(final RequestLocal appTypeRL, RequestLocal portalsiteRL, final RequestLocal makeLocal, final ActionListener onNext, final ActionListener onCancel) {
        final Form f = new Form("newexist", (Container)new BoxPanel(2)){

            public void generateXML(PageState ps, Element parent) {
                this.getFormData(ps);
                super.generateXML(ps, parent);
            }
        };
        final Label info = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.choose_new_or_existing"));
        f.add((Component)info);
        final RadioGroup rg = new RadioGroup("select");
        rg.setLayout(2);
        final Label newLabel = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.create_new"), false);
        final Label existingLabel = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.pick_existing"), false);
        rg.addOption(new Option("local", (Component)newLabel));
        rg.addOption(new Option("external", (Component)existingLabel));
        rg.setOptionSelected("local");
        f.add((Component)rg);
        BoxPanel buttons = new BoxPanel(1);
        Submit next = new Submit("Next >>");
        final Submit cancel = new Submit("Cancel");
        buttons.add((Component)next);
        buttons.add((Component)cancel);
        f.add((Component)buttons);
        f.addInitListener(new FormInitListener(){

            public void init(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                ApplicationType type = (ApplicationType)appTypeRL.get(ps);
                String title = type.getTitle();
                title = title.toLowerCase();
                info.setLabel("You can choose which " + title + " to display in the new portlet.", ps);
                newLabel.setLabel("I want to display the " + title + " for this portal in the portlet.", ps);
                existingLabel.setLabel("I want to choose a " + title + " from another portal to display in the portlet.", ps);
            }
        });
        f.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                if (cancel.isSelected(ps)) {
                    onCancel.actionPerformed(new ActionEvent((Component)f, ps));
                    return;
                }
                String value = (String)rg.getValue(ps);
                if ("local".equals(value)) {
                    makeLocal.set(ps, (Object)Boolean.TRUE);
                } else if ("external".equals(value)) {
                    makeLocal.set(ps, (Object)Boolean.FALSE);
                } else {
                    throw new IllegalStateException("invalid selection");
                }
                onNext.actionPerformed(new ActionEvent((Component)f, ps));
            }
        });
        f.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                if (cancel.isSelected(ps)) {
                    onCancel.actionPerformed(new ActionEvent((Component)f, ps));
                    return;
                }
            }
        });
        return f;
    }

    private static Form buildAppSelect(final RequestLocal appType, RequestLocal portalsiteRL, final RequestLocal selectedApp, final ActionListener onNext, final ActionListener onBack, final ActionListener onCancel) {
        final Form f = new Form("appselect", (Container)new BoxPanel(2)){

            public void generateXML(PageState ps, Element parent) {
                this.getFormData(ps);
                super.generateXML(ps, parent);
            }
        };
        SimpleContainer header = new SimpleContainer();
        Label header1 = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.you_have_opted_to_display_an_existing"));
        final Label header2 = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.apptype"));
        Label header3 = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.in_the_new_portlet"));
        header.add((Component)header1);
        header.add((Component)header2);
        header.add((Component)header3);
        f.add((Component)header);
        SimpleContainer choose = new SimpleContainer();
        Label choose1 = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.choose_one_of_the"));
        final Label choose2 = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.apptype"));
        Label choose3 = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.already_in_this_workspace"));
        choose.add((Component)choose1);
        choose.add((Component)choose2);
        choose.add((Component)choose3);
        f.add((Component)choose);
        final RadioGroup rg = new RadioGroup("appselect");
        rg.setLayout(2);
        f.add((Component)rg);
        BoxPanel buttons = new BoxPanel(1);
        Submit next = new Submit("Next >>");
        buttons.add((Component)next);
        final Submit back = new Submit("Back <<");
        buttons.add((Component)back);
        final Submit cancel = new Submit("Cancel");
        buttons.add((Component)cancel);
        f.add((Component)buttons);
        f.addInitListener(new FormInitListener(){

            public void init(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                ApplicationType type = (ApplicationType)appType.get(ps);
                String title = type.getTitle();
                title = title.toLowerCase();
                header2.setLabel(title, ps);
                choose2.setLabel(title, ps);
                ApplicationCollection ac = PortletAddForm.getApplicationChoices(type);
                ac.orderByParentTitle();
                ac.orderByTitle();
                while (ac.next()) {
                    Label l = new Label(ac.getTitle() + " ( " + ac.getParentTitle() + " ) ");
                    l.setFontWeight("b");
                    rg.addOption(new Option(ac.getID().toString(), (Component)l), ps);
                }
            }
        });
        f.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                String idStr = (String)rg.getValue(ps);
                if (cancel.isSelected(ps)) {
                    onCancel.actionPerformed(new ActionEvent((Component)f, ps));
                    return;
                }
                if (back.isSelected(ps)) {
                    onBack.actionPerformed(new ActionEvent((Component)f, ps));
                    return;
                }
                try {
                    BigDecimal id = new BigDecimal(idStr);
                    selectedApp.set(ps, (Object)Application.retrieveApplication((BigDecimal)id));
                    onNext.actionPerformed(new ActionEvent((Component)f, ps));
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalStateException("bad id");
                }
            }
        });
        f.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                if (cancel.isSelected(ps)) {
                    onCancel.actionPerformed(new ActionEvent((Component)f, ps));
                    return;
                }
            }
        });
        return f;
    }

    private static ApplicationCreateComponent buildAppCreate(final RequestLocal appTypeRL, RequestLocal portalsiteRL, final RequestLocal createdAppRL, final ActionListener onNext, final ActionListener onBack, final ActionListener onCancel) {
        return new ApplicationCreateComponent(appTypeRL, portalsiteRL, false, new ApplicationCreateComponent.Builder(){

            public Component build(ResourceConfigFormSection acfs) {
                Form f = new Form(this, "appcreate", (Container)new BoxPanel(2)){
                    private final /* synthetic */ 27 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void generateXML(PageState ps, Element parent) {
                        this.getFormData(ps);
                        super.generateXML(ps, parent);
                    }
                };
                SimpleContainer header = new SimpleContainer();
                Label header1 = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.you_chose_to_create_a_new"));
                Label header2 = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.apptype"));
                Label header3 = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.in_the_new_portlet"));
                header.add((Component)header1);
                header.add((Component)header2);
                header.add((Component)header3);
                f.add((Component)header);
                f.add((Component)acfs);
                BoxPanel buttons = new BoxPanel(1);
                Submit next = new Submit("Next >>");
                buttons.add((Component)next);
                Submit back = new Submit("Back <<");
                buttons.add((Component)back);
                Submit cancel = new Submit("Cancel");
                buttons.add((Component)cancel);
                f.add((Component)buttons);
                f.addInitListener(new FormInitListener(this, header2){
                    private final /* synthetic */ Label val$header2;
                    private final /* synthetic */ 27 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$header2 = val$header2;
                    }

                    public void init(FormSectionEvent ev) {
                        PageState ps = ev.getPageState();
                        ApplicationType type = (ApplicationType)27.access$1100(this.this$0).get(ps);
                        String title = type.getTitle();
                        title = title.toLowerCase();
                        this.val$header2.setLabel(title, ps);
                    }
                });
                f.addProcessListener(new FormProcessListener(this, next, acfs, f, back, cancel){
                    private final /* synthetic */ Submit val$next;
                    private final /* synthetic */ ResourceConfigFormSection val$acfs;
                    private final /* synthetic */ Form val$f;
                    private final /* synthetic */ Submit val$back;
                    private final /* synthetic */ Submit val$cancel;
                    private final /* synthetic */ 27 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$next = val$next;
                        this.val$acfs = val$acfs;
                        this.val$f = val$f;
                        this.val$back = val$back;
                        this.val$cancel = val$cancel;
                    }

                    public void process(FormSectionEvent ev) throws FormValidationException {
                        PageState ps = ev.getPageState();
                        if (this.val$next.isSelected(ps)) {
                            if (PortletAddForm.access$1200().isDebugEnabled()) {
                                PortletAddForm.access$1200().debug((Object)("Using application config form section " + this.val$acfs + " to create an application"));
                            }
                            Application app = (Application)this.val$acfs.createResource(ps);
                            27.access$1300(this.this$0).set(ps, (Object)app);
                            27.access$1400(this.this$0).actionPerformed(new ActionEvent((Component)this.val$f, ps));
                            PortletAddForm.access$1500((Resource)app);
                        } else if (this.val$back.isSelected(ps)) {
                            27.access$1600(this.this$0).actionPerformed(new ActionEvent((Component)this.val$f, ps));
                        } else if (this.val$cancel.isSelected(ps)) {
                            27.access$1700(this.this$0).actionPerformed(new ActionEvent((Component)this.val$f, ps));
                        }
                    }
                });
                f.addSubmissionListener(new FormSubmissionListener(this, cancel, f){
                    private final /* synthetic */ Submit val$cancel;
                    private final /* synthetic */ Form val$f;
                    private final /* synthetic */ 27 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$cancel = val$cancel;
                        this.val$f = val$f;
                    }

                    public void submitted(FormSectionEvent ev) {
                        PageState ps = ev.getPageState();
                        if (this.val$cancel.isSelected(ps)) {
                            27.access$1700(this.this$0).actionPerformed(new ActionEvent((Component)this.val$f, ps));
                            return;
                        }
                    }
                });
                return f;
            }

            static /* synthetic */ RequestLocal access$1100(27 x0) {
                return x0.appTypeRL;
            }

            static /* synthetic */ RequestLocal access$1300(27 x0) {
                return x0.createdAppRL;
            }

            static /* synthetic */ ActionListener access$1400(27 x0) {
                return x0.onNext;
            }

            static /* synthetic */ ActionListener access$1600(27 x0) {
                return x0.onBack;
            }

            static /* synthetic */ ActionListener access$1700(27 x0) {
                return x0.onCancel;
            }
        });
    }

    private static ApplicationCreateComponent buildPortletCreate(final RequestLocal portletTypeRL, RequestLocal parentAppRL, final RequestLocal portletRL, final ActionListener onNext, final ActionListener onCancel) {
        return new ApplicationCreateComponent(portletTypeRL, parentAppRL, true, new ApplicationCreateComponent.Builder(){

            public Component build(ResourceConfigFormSection acfs) {
                Form f = new Form(this, "portcreat", (Container)new BoxPanel(2)){
                    private final /* synthetic */ 32 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void generateXML(PageState ps, Element p) {
                        this.getFormData(ps);
                        super.generateXML(ps, p);
                    }
                };
                SimpleContainer header = new SimpleContainer();
                Label header1 = new Label("Choose display options for the new ");
                Label header2 = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.apptype"));
                Label header2a = new Label(" ");
                Label header3 = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.portlet"));
                header.add((Component)header1);
                header.add((Component)header2);
                header.add((Component)header2a);
                header.add((Component)header3);
                f.add((Component)header);
                f.add((Component)acfs);
                BoxPanel buttons = new BoxPanel(1);
                Submit next = new Submit("Next >>");
                buttons.add((Component)next);
                Submit cancel = new Submit("Cancel");
                buttons.add((Component)cancel);
                f.add((Component)buttons);
                f.addInitListener(new FormInitListener(this, header2){
                    private final /* synthetic */ Label val$header2;
                    private final /* synthetic */ 32 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$header2 = val$header2;
                    }

                    public void init(FormSectionEvent ev) {
                        PageState ps = ev.getPageState();
                        ResourceType type = (ResourceType)32.access$1800(this.this$0).get(ps);
                        String title = type.getTitle();
                        title = title.toLowerCase();
                        this.val$header2.setLabel(title, ps);
                    }
                });
                f.addProcessListener(new FormProcessListener(this, acfs, next, f, cancel){
                    private final /* synthetic */ ResourceConfigFormSection val$acfs;
                    private final /* synthetic */ Submit val$next;
                    private final /* synthetic */ Form val$f;
                    private final /* synthetic */ Submit val$cancel;
                    private final /* synthetic */ 32 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$acfs = val$acfs;
                        this.val$next = val$next;
                        this.val$f = val$f;
                        this.val$cancel = val$cancel;
                    }

                    public void process(FormSectionEvent ev) {
                        PageState ps = ev.getPageState();
                        if (PortletAddForm.access$1200().isDebugEnabled()) {
                            PortletAddForm.access$1200().debug((Object)("Using application config form section " + this.val$acfs + " to create a new portlet"));
                        }
                        if (this.val$next.isSelected(ps)) {
                            Resource app = this.val$acfs.createResource(ps);
                            32.access$1900(this.this$0).set(ps, (Object)app);
                            32.access$2000(this.this$0).actionPerformed(new ActionEvent((Component)this.val$f, ps));
                            PortletAddForm.access$1500(app);
                        } else if (this.val$cancel.isSelected(ps)) {
                            32.access$2100(this.this$0).actionPerformed(new ActionEvent((Component)this.val$f, ps));
                        }
                    }
                });
                f.addSubmissionListener(new FormSubmissionListener(this, cancel, f){
                    private final /* synthetic */ Submit val$cancel;
                    private final /* synthetic */ Form val$f;
                    private final /* synthetic */ 32 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$cancel = val$cancel;
                        this.val$f = val$f;
                    }

                    public void submitted(FormSectionEvent ev) {
                        PageState ps = ev.getPageState();
                        if (this.val$cancel.isSelected(ps)) {
                            32.access$2100(this.this$0).actionPerformed(new ActionEvent((Component)this.val$f, ps));
                            return;
                        }
                    }
                });
                return f;
            }

            static /* synthetic */ RequestLocal access$1800(32 x0) {
                return x0.portletTypeRL;
            }

            static /* synthetic */ RequestLocal access$1900(32 x0) {
                return x0.portletRL;
            }

            static /* synthetic */ ActionListener access$2000(32 x0) {
                return x0.onNext;
            }

            static /* synthetic */ ActionListener access$2100(32 x0) {
                return x0.onCancel;
            }
        });
    }

    private void addToTab(PageState ps, Portlet newPortlet) {
        BigDecimal ptabID = (BigDecimal)this.m_portalIDRL.get(ps);
        PortalTab ptab = PortalTab.retrieveTab(ptabID);
        String column = (String)ps.getValue((ParameterModel)this.m_columnParam);
        if (column == null) {
            if (newPortlet.getProfile().equals("wide")) {
                ptab.addPortlet(newPortlet, 2);
            } else {
                ptab.addPortlet(newPortlet, 1);
            }
        } else if (LEFT_COLUMN.equals(ps.getValue((ParameterModel)this.m_columnParam))) {
            ptab.addPortlet(newPortlet, 1);
        } else {
            ptab.addPortlet(newPortlet, 2);
        }
        ptab.save();
        newPortlet.save();
    }

    private static final void grantWrite(final Resource app) {
        final Party current = Kernel.getContext().getParty();
        if (current == null || current.equals((Object)Kernel.getSystemParty())) {
            return;
        }
        new KernelExcursion(){

            public void excurse() {
                this.setParty(Kernel.getSystemParty());
                app.save();
                PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.WRITE, (ACSObject)app, current));
            }
        }.run();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ Logger access$1200() {
        return s_log;
    }

    static /* synthetic */ void access$1500(Resource x0) {
        PortletAddForm.grantWrite(x0);
    }
}

