/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui.admin;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.CompoundComponent;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.ui.ResourceConfigFormSection;
import com.arsdigita.portal.PortletType;
import com.arsdigita.portal.PortletTypeCollection;
import com.arsdigita.web.ApplicationType;
import com.arsdigita.web.ApplicationTypeCollection;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ApplicationCreateComponent
extends CompoundComponent {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/ui/admin/ApplicationCreateComponent.java#4 $$Author: jorris $$DateTime: 2003/11/24 15:29:26 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$portalserver$ui$admin$ApplicationCreateComponent == null ? (class$com$arsdigita$portalserver$ui$admin$ApplicationCreateComponent = ApplicationCreateComponent.class$("com.arsdigita.portalserver.ui.admin.ApplicationCreateComponent")) : class$com$arsdigita$portalserver$ui$admin$ApplicationCreateComponent));
    private RequestLocal m_appTypeRL;
    private HashMap m_configureComponents;
    static /* synthetic */ Class class$com$arsdigita$portalserver$ui$admin$ApplicationCreateComponent;

    public ApplicationCreateComponent(RequestLocal appTypeRL, RequestLocal parentApplicationRL, boolean forPortlets, ActionListener onSuccess, ActionListener onCancel) {
        this(appTypeRL, parentApplicationRL, forPortlets, new DefaultBuilder(onSuccess, onCancel));
    }

    public ApplicationCreateComponent(RequestLocal appTypeRL, RequestLocal parentApplicationRL, boolean forPortlets, Builder builder) {
        this.m_appTypeRL = appTypeRL;
        this.m_configureComponents = new HashMap();
        if (forPortlets) {
            s_log.debug((Object)"Building a portlet create component");
            PortletTypeCollection types = PortletType.retrieveAllPortletTypes();
            while (types.next()) {
                PortletType type = types.getPortletType();
                ResourceConfigFormSection config = type.getCreateFormSection(parentApplicationRL);
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Fetched config " + config + " for type '" + type.getTitle() + "' with ID " + type.getID()));
                }
                if (config == null) continue;
                Component c = builder.build(config);
                this.m_configureComponents.put(type.getID(), c);
                this.add(c);
            }
        } else {
            s_log.debug((Object)"Building an application create component");
            ApplicationTypeCollection types = ApplicationType.retrieveAllApplicationTypes();
            while (types.next()) {
                ApplicationType type = types.getApplicationType();
                ResourceConfigFormSection config = type.getCreateFormSection(parentApplicationRL);
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Fetched config " + config + " for type '" + type.getTitle() + "'"));
                }
                if (config == null) continue;
                Component c = builder.build(config);
                this.m_configureComponents.put(type.getID(), c);
                this.add(c);
            }
        }
    }

    public Component get(PageState ps) {
        ResourceType rt = (ResourceType)this.m_appTypeRL.get(ps);
        if (!this.canCreate(rt)) {
            throw new IllegalStateException("can not display form for a: " + rt.getTitle());
        }
        return (Component)this.m_configureComponents.get(rt.getID());
    }

    public void generateXML(PageState ps, Element parentElt) {
        Component c = this.get(ps);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Generating XML of component " + c + " fetched " + "using ID " + ((ResourceType)this.m_appTypeRL.get(ps)).getID()));
        }
        c.generateXML(ps, parentElt);
    }

    public boolean canCreate(BigDecimal appTypeID) {
        return this.m_configureComponents.containsKey(appTypeID);
    }

    public boolean canCreate(ResourceType rt) {
        return this.m_configureComponents.containsKey(rt.getID());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DefaultBuilder
    implements Builder {
        private final ActionListener m_onSuccess;
        private final ActionListener m_onCancel;

        public DefaultBuilder(ActionListener onSuccess, ActionListener onCancel) {
            this.m_onSuccess = onSuccess;
            this.m_onCancel = onCancel;
        }

        public Component build(ResourceConfigFormSection acfs) {
            Form f = new Form("ac", (Container)new GridPanel(1));
            f.add((Component)acfs);
            BoxPanel buttons = new BoxPanel(1);
            Submit create = new Submit("Create");
            Submit cancel = new Submit("Cancel");
            buttons.add((Component)create);
            buttons.add((Component)cancel);
            f.add((Component)buttons);
            f.addProcessListener(new FormProcessListener(this, create, acfs, f, cancel){
                private final /* synthetic */ Submit val$create;
                private final /* synthetic */ ResourceConfigFormSection val$acfs;
                private final /* synthetic */ Form val$f;
                private final /* synthetic */ Submit val$cancel;
                private final /* synthetic */ DefaultBuilder this$0;
                {
                    this.this$0 = this$0;
                    this.val$create = val$create;
                    this.val$acfs = val$acfs;
                    this.val$f = val$f;
                    this.val$cancel = val$cancel;
                }

                public void process(FormSectionEvent ev) throws FormProcessException {
                    PageState ps = ev.getPageState();
                    if (this.val$create.isSelected(ps)) {
                        this.val$acfs.createResource(ps).save();
                        DefaultBuilder.access$000(this.this$0).actionPerformed(new ActionEvent((Component)this.val$f, ps));
                    } else if (this.val$cancel.isSelected(ps)) {
                        DefaultBuilder.access$100(this.this$0).actionPerformed(new ActionEvent((Component)this.val$f, ps));
                    }
                }
            });
            return f;
        }

        static /* synthetic */ ActionListener access$000(DefaultBuilder x0) {
            return x0.m_onSuccess;
        }

        static /* synthetic */ ActionListener access$100(DefaultBuilder x0) {
            return x0.m_onCancel;
        }
    }

    public static interface Builder {
        public Component build(ResourceConfigFormSection var1);
    }
}

