/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.personal;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.DimensionalNavbar;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.permissions.UniversalPermissionDescriptor;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.personal.PersonalPortal;
import com.arsdigita.portalserver.ui.PortalHomePage;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import com.arsdigita.util.Assert;

public class PersonalPortalHomePage
extends PortalHomePage {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/personal/PersonalPortalHomePage.java#7 $$Author: dennis $$DateTime: 2003/08/15 13:46:34 $";
    private final RequestLocal m_adminPermission = new RequestLocal(){

        protected Object initialValue(PageState state) {
            UniversalPermissionDescriptor descriptor = new UniversalPermissionDescriptor(PrivilegeDescriptor.ADMIN, Kernel.getContext().getParty());
            if (PermissionService.checkPermission((PermissionDescriptor)descriptor)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    };

    protected void buildHeader(Container header) {
        Link profileLink = new Link((Component)new Label(GlobalizationUtil.globalize("cw.workspace.personal.edit_your_profile")), "/register/edit-profile");
        profileLink.setClassAttr("portalControlProfileLink");
        header.add((Component)profileLink);
        Link passwordLink = new Link((Component)new Label(GlobalizationUtil.globalize("cw.workspace.personal.change_your_password")), "/register/change-password");
        passwordLink.setClassAttr("portalControlProfileLink");
        header.add((Component)passwordLink);
        Link adminLink = new Link((Component)new Label(GlobalizationUtil.globalize("cw.workspace.personal.site_administration")), "/portal-admin/"){

            public boolean isVisible(PageState state) {
                Boolean bool = (Boolean)PersonalPortalHomePage.this.m_adminPermission.get(state);
                return bool;
            }
        };
        adminLink.setClassAttr("portalControlProfileLink");
        header.add((Component)adminLink);
        super.buildHeader(header);
    }

    protected void buildTitle() {
        class TitlePrintListener
        implements PrintListener {
            TitlePrintListener() {
            }

            public void prepare(PrintEvent e) {
                PageState pageState = e.getPageState();
                PortalSite psite = PortalSite.getCurrentPortalSite(pageState.getRequest());
                Assert.assertTrue((boolean)(psite instanceof PersonalPortal));
                PersonalPortal pp = (PersonalPortal)psite;
                User user = pp.getOwningUser();
                String givenName = user.getPersonName().getGivenName();
                Label target = (Label)e.getTarget();
                if (givenName.endsWith("s")) {
                    target.setLabel(givenName + "' " + pp.getTitle());
                } else {
                    target.setLabel(givenName + "'s " + pp.getTitle());
                }
            }
        }
        this.setTitle(new Label((PrintListener)new TitlePrintListener()));
    }

    protected void buildContextBar() {
        DimensionalNavbar navbar = new DimensionalNavbar();
        navbar.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.personal.personal_workspace")));
        navbar.setClassAttr("portalNavbar");
        this.getHeader().add((Component)navbar);
    }
}

