/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.permissions;

import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.metadata.ObjectType;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

class Grant {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/permissions/Grant.java#4 $$Author: akananov $$DateTime: 2004/03/11 08:58:05 $";
    private static Logger s_log = Logger.getLogger((String)(class$com$arsdigita$portalserver$permissions$Grant == null ? (class$com$arsdigita$portalserver$permissions$Grant = Grant.class$("com.arsdigita.portalserver.permissions.Grant")) : class$com$arsdigita$portalserver$permissions$Grant).getName());
    static final PrivilegeDescriptor[] s_interestingPrivileges = new PrivilegeDescriptor[]{PrivilegeDescriptor.READ, PrivilegeDescriptor.EDIT, PrivilegeDescriptor.ADMIN};
    static final PrivilegeDescriptor[] s_privileges = new PrivilegeDescriptor[]{PrivilegeDescriptor.READ, PrivilegeDescriptor.EDIT, PrivilegeDescriptor.ADMIN, PrivilegeDescriptor.CREATE};
    static final String[] s_privilegePrettyNames = new String[]{"Read", "Edit", "Manage"};
    static final int CREATE = 3;
    static final int ADMIN = 2;
    static final int EDIT = 1;
    static final int READ = 0;
    public BigDecimal granteeID;
    public String granteeName;
    public boolean granteeIsUser;
    public BigDecimal objectID;
    public String objectName;
    public PrivilegeDescriptor basePrivilege;
    public ObjectType objectType = null;
    public String objectTypeDisplayName = null;
    public int level;
    static /* synthetic */ Class class$com$arsdigita$portalserver$permissions$Grant;

    Grant() {
    }

    static int getPrivilegeLevel(PrivilegeDescriptor priv) {
        if (PrivilegeDescriptor.EDIT.equals((Object)priv)) {
            return 1;
        }
        if (PrivilegeDescriptor.ADMIN.equals((Object)priv)) {
            return 2;
        }
        if (PrivilegeDescriptor.READ.equals((Object)priv)) {
            return 0;
        }
        if (PrivilegeDescriptor.CREATE.equals((Object)priv)) {
            return 3;
        }
        return -1;
    }

    public int hashCode() {
        if (this.objectType == null) {
            return this.granteeID.hashCode() + this.objectID.hashCode();
        }
        return this.granteeID.hashCode() + this.objectID.hashCode() + this.objectType.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Grant)) {
            return false;
        }
        Grant otherGrant = (Grant)other;
        if (!this.granteeID.equals(otherGrant.granteeID)) {
            return false;
        }
        if (!this.objectID.equals(otherGrant.objectID)) {
            return false;
        }
        if (this.objectType == null && otherGrant.objectType == null) {
            return true;
        }
        if (this.objectType == null || otherGrant.objectType == null) {
            return false;
        }
        return this.objectType.equals((Object)otherGrant.objectType);
    }

    public String toString() {
        return Grant.marshal(this.granteeID, this.objectID, this.basePrivilege, this.objectType);
    }

    void populatePrivilege(PrivilegeDescriptor priv) {
        this.basePrivilege = priv;
        this.level = Grant.getPrivilegeLevel(priv);
        this.objectTypeDisplayName = "All Types";
    }

    static Grant unmarshal(String encoded) {
        Grant result = new Grant();
        int dot1 = encoded.indexOf(46);
        int dot2 = encoded.indexOf(46, dot1 + 1);
        int dot3 = encoded.indexOf(46, dot2 + 1);
        result.granteeID = new BigDecimal(encoded.substring(0, dot1));
        result.objectID = new BigDecimal(encoded.substring(dot1 + 1, dot2));
        result.basePrivilege = PrivilegeDescriptor.get((String)encoded.substring(dot2 + 1, dot3));
        result.level = Grant.getPrivilegeLevel(result.basePrivilege);
        if (dot3 + 1 < encoded.length()) {
            String objectTypeName = encoded.substring(dot3 + 1);
            result.objectType = MetadataRoot.getMetadataRoot().getObjectType(objectTypeName);
        }
        return result;
    }

    private static String marshal(BigDecimal granteeID, BigDecimal objectID, PrivilegeDescriptor privilege, ObjectType objectType) {
        if (objectType != null) {
            return granteeID + "." + objectID + "." + privilege.getName() + "." + objectType.getQualifiedName();
        }
        return granteeID + "." + objectID + "." + privilege.getName() + ".";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

