/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.kernel.Resource;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.DataQueryDataCollectionAdapter;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.portal.AgentPortlet;
import com.arsdigita.portal.Portal;
import com.arsdigita.portal.Portlet;
import com.arsdigita.portal.PortletCollection;
import com.arsdigita.portal.apportlet.AppPortlet;
import com.arsdigita.portalserver.PortalSiteCollection;
import com.arsdigita.portalserver.PortalTab;
import com.arsdigita.portalserver.PortalTabCollection;
import com.arsdigita.portalserver.Role;
import com.arsdigita.portalserver.RoleCollection;
import com.arsdigita.portalserver.SubPortalTab;
import com.arsdigita.portalserver.Theme;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationCollection;
import com.arsdigita.web.ApplicationType;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Category;

public class PortalSite
extends Application {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.workspace.Workspace";
    private static final String PARTICIPANT_ID_QUERY = "com.arsdigita.workspace.WorkspaceParticipantIDs";
    private static Category s_log = Category.getInstance((Class)(class$com$arsdigita$portalserver$PortalSite == null ? (class$com$arsdigita$portalserver$PortalSite = PortalSite.class$("com.arsdigita.portalserver.PortalSite")) : class$com$arsdigita$portalserver$PortalSite));
    private static final int SORT_KEY_JUMP = 10;
    private Role m_memberRole;
    private boolean m_wasNew = false;
    static /* synthetic */ Class class$com$arsdigita$portalserver$PortalSite;

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    protected PortalSite(DataObject dataObject) {
        super(dataObject);
    }

    protected void initialize() {
        super.initialize();
        if (this.isNew()) {
            this.setReady(false);
            this.setDraft(false);
            this.setPersonalizable(false);
            this.setUnarchived();
            this.setCreationDate();
        }
    }

    public static PortalSite createPortalSite(String urlName, String title, PortalSite parent, boolean inheritPermissions) {
        ApplicationType type = ApplicationType.retrieveApplicationTypeForApplication((String)BASE_DATA_OBJECT_TYPE);
        PortalSite ps = (PortalSite)Application.createApplication((ApplicationType)type, (String)urlName, (String)title, (Application)parent);
        ps.setUnarchived();
        ps.setDraft(false);
        ps.setCreationDate();
        ps.setPersonalizable(false);
        if (!inheritPermissions) {
            PermissionService.setContext((ACSObject)ps, null);
        }
        return ps;
    }

    public static PortalSite createPortalSite(String urlName, String title, PortalSite parent) {
        ApplicationType type = ApplicationType.retrieveApplicationTypeForApplication((String)BASE_DATA_OBJECT_TYPE);
        PortalSite ps = (PortalSite)Application.createApplication((ApplicationType)type, (String)urlName, (String)title, (Application)parent);
        ps.setUnarchived();
        ps.setDraft(false);
        ps.setCreationDate();
        ps.setPersonalizable(false);
        return ps;
    }

    public static PortalSiteCollection retrieveAll() {
        return PortalSite.retrieveAllPortalSites();
    }

    public static PortalSiteCollection retrieveAllPortalSites() {
        DataCollection dataCollection = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        PortalSiteCollection portalsiteCollection = new PortalSiteCollection(dataCollection);
        return portalsiteCollection;
    }

    public static PortalSiteCollection retrieveAllActivePortalSites() {
        DataCollection dataCollection = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        PortalSiteCollection portalsiteCollection = new PortalSiteCollection(dataCollection);
        portalsiteCollection.filterForArchived();
        return portalsiteCollection;
    }

    public static PortalSite retrievePortalSiteForSiteNode(SiteNode siteNode) {
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.workspace.workspaceForSiteNodeID");
        query.setParameter("siteNodeID", (Object)siteNode.getID());
        PortalSite portalsite = null;
        if (query.next()) {
            DataObject dataObject = (DataObject)query.get("workspace");
            portalsite = PortalSite.retrievePortalSite(dataObject);
        }
        query.close();
        return portalsite;
    }

    public static PortalSite retrievePortalSite(BigDecimal id) {
        return (PortalSite)Application.retrieveApplication((BigDecimal)id);
    }

    public static PortalSite retrievePortalSite(OID oid) {
        return (PortalSite)Application.retrieveApplication((OID)oid);
    }

    public static PortalSite retrievePortalSite(DataObject dataObject) {
        return (PortalSite)Application.retrieveApplication((DataObject)dataObject);
    }

    protected void beforeSave() {
        this.m_wasNew = this.isNew();
        super.beforeSave();
    }

    protected void afterSave() {
        super.afterSave();
        if (this.m_wasNew) {
            Role role = Role.createRole(this, "Members", "Member", "", true, "members");
            this.setMemberRole(role);
            role.save();
            PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.READ, (ACSObject)this, (Party)this.getMemberRole()));
            PortalSite parent = PortalSite.getPortalSiteForApplication(this);
            if (parent != null) {
                parent.addMember((Party)this.getMemberRole());
                parent.save();
            }
            this.m_wasNew = false;
        }
    }

    protected void beforeDelete() {
        PortalSiteCollection psc = this.getAllChildPortalSites();
        if (!psc.isEmpty()) {
            throw new UnsupportedOperationException("Deletion of PortalSites does not support recursion: youmust delete children of this portal site first.");
        }
    }

    public ApplicationCollection getFullPagePortalSiteApplications() {
        ApplicationCollection applications = this.getChildApplications();
        applications.filterToPortalSiteApplications();
        applications.filterToHasFullPageView();
        return applications;
    }

    public boolean isAppTypeInPortalSite(ApplicationType appType) {
        ApplicationCollection apps = this.getFullPagePortalSiteApplications();
        while (apps.next()) {
            ApplicationType atp = apps.getApplication().getApplicationType();
            if (!atp.getID().equals(appType.getID())) continue;
            apps.close();
            return true;
        }
        apps.close();
        return false;
    }

    public PortalSiteCollection getChildPortalSites() {
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.workspace.childWorkspacesForApplicationID");
        query.setParameter("applicationID", (Object)this.getID());
        DataQueryDataCollectionAdapter collection = new DataQueryDataCollectionAdapter(query, "workspace");
        query.close();
        PortalSiteCollection psc = new PortalSiteCollection((DataCollection)collection);
        psc.filterForUnarchived();
        return psc;
    }

    public PortalSiteCollection getAllChildPortalSites() {
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.workspace.childWorkspacesForApplicationID");
        query.setParameter("applicationID", (Object)this.getID());
        DataQueryDataCollectionAdapter collection = new DataQueryDataCollectionAdapter(query, "workspace");
        query.close();
        return new PortalSiteCollection((DataCollection)collection);
    }

    public PortalSiteCollection getRelatedPortalSites() {
        DataAssociation association = (DataAssociation)this.get("relatedWorkspace");
        PortalSiteCollection psc = new PortalSiteCollection((DataCollection)association.cursor());
        psc.filterForUnarchived();
        return psc;
    }

    public PortalSiteCollection getAllRelatedPortalSites() {
        DataAssociation association = (DataAssociation)this.get("relatedWorkspace");
        PortalSiteCollection psc = new PortalSiteCollection((DataCollection)association.cursor());
        return psc;
    }

    public static PortalSite getPortalSiteForApplication(Application app) {
        Application application = app.getParentApplication();
        if (application == null) {
            return null;
        }
        if (!(application instanceof PortalSite)) {
            return null;
        }
        return (PortalSite)application;
    }

    public static PortalSite getPortalSiteForAppPortlet(AppPortlet portlet) {
        Resource parentRes = portlet.getParentResource();
        if (parentRes == null) {
            return null;
        }
        if (!(parentRes instanceof Application)) {
            return null;
        }
        if (parentRes instanceof PortalSite) {
            return (PortalSite)parentRes;
        }
        return PortalSite.getPortalSiteForApplication((Application)parentRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PortalSite getCurrentPortalSite(HttpServletRequest request) {
        String key = "com.arsdigita.workspace.Workspace.currentWorkspace";
        PortalSite currentPortalSite = null;
        HttpServletRequest httpServletRequest = request;
        synchronized (httpServletRequest) {
            currentPortalSite = (PortalSite)((Object)request.getAttribute(key));
            if (currentPortalSite == null) {
                currentPortalSite = PortalSite.doGetCurrentPortalSite(request);
                request.setAttribute(key, (Object)currentPortalSite);
            }
        }
        return currentPortalSite;
    }

    private static PortalSite doGetCurrentPortalSite(HttpServletRequest request) {
        Application application = Application.getCurrentApplication((HttpServletRequest)request);
        if (application instanceof PortalSite) {
            return (PortalSite)application;
        }
        do {
            if (application != null) continue;
            return null;
        } while (!((application = application.getParentApplication()) instanceof PortalSite));
        return (PortalSite)application;
    }

    public static PortalSiteCollection getRootPortalSites() {
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.workspace.rootWorkspaces");
        DataQueryDataCollectionAdapter collection = new DataQueryDataCollectionAdapter(query, "workspace");
        query.close();
        PortalSiteCollection psc = new PortalSiteCollection((DataCollection)collection);
        psc.filterForUnarchived();
        return psc;
    }

    public static PortalSiteCollection getAllRootPortalSites() {
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.workspace.rootWorkspaces");
        Application app = Application.retrieveApplicationForPath((String)"/personal-portal/");
        if (app != null) {
            query.setParameter("parentID", (Object)app.getID());
        }
        DataQueryDataCollectionAdapter collection = new DataQueryDataCollectionAdapter(query, "workspace");
        query.close();
        return new PortalSiteCollection((DataCollection)collection);
    }

    public void addRelatedPortalSite(PortalSite portalsite) {
        this.add("relatedWorkspace", (DomainObject)portalsite);
    }

    public void removeRelatedPortalSite(PortalSite portalsite) {
        this.remove("relatedWorkspace", (DomainObject)portalsite);
    }

    public boolean isDirectParticipant(Party party) {
        DataAssociationCursor dac = ((DataAssociation)this.get("participants")).cursor();
        dac.addEqualsFilter("id", (Object)party.getID());
        return dac.size() != 0L;
    }

    public boolean isParticipant(Party party) {
        throw new UnsupportedOperationException();
    }

    public boolean isDirectMember(Party party) {
        Role g = this.getMemberRole();
        return g.hasDirectMemberOrSubgroup(party);
    }

    public boolean isMember(Party party) {
        Role g = this.getMemberRole();
        if (party instanceof User) {
            return g.hasMember((Party)((User)party));
        }
        if (party instanceof Group) {
            return g.hasSubgroup((Group)party);
        }
        throw new IllegalArgumentException("party must be a user or a group");
    }

    public void addMember(Party member) {
        this.addParticipant(member);
        Role g = this.getMemberRole();
        if (member instanceof User) {
            User u = (User)member;
            g.addMember(u);
        } else if (member instanceof Group) {
            Group pGroup = (Group)member;
            g.addSubgroup(pGroup);
        } else {
            throw new IllegalArgumentException("party must be a user or a group");
        }
    }

    public void addParticipant(Party participant) {
        this.addParticipant(participant, true);
    }

    public void addParticipant(Party participant, boolean addDefaultPriv) {
        this.add("participants", (DomainObject)participant);
        if (addDefaultPriv) {
            PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.READ, (ACSObject)this, participant));
        }
    }

    public void removeParticipant(Party participant) {
        Role r;
        RoleCollection rc = this.getRoles();
        if (participant instanceof User) {
            while (rc.next()) {
                r = rc.getRole();
                r.removeMember((User)participant);
                r.save();
            }
        } else if (participant instanceof Group) {
            while (rc.next()) {
                r = rc.getRole();
                r.removeSubgroup((Group)participant);
                r.save();
            }
        } else {
            throw new IllegalArgumentException("received party that was neither user nor group");
        }
        this.remove("participants", (DomainObject)participant);
        Iterator privIter = PermissionService.getDirectPrivileges((OID)this.getOID(), (OID)participant.getOID());
        while (privIter.hasNext()) {
            PrivilegeDescriptor priv = (PrivilegeDescriptor)privIter.next();
            PermissionService.revokePermission((PermissionDescriptor)new PermissionDescriptor(priv, (ACSObject)this, participant));
        }
        ApplicationCollection ac = this.getFullPagePortalSiteApplications();
        while (ac.next()) {
            OID appOID = new OID(ac.getSpecificObjectType(), (Object)ac.getID());
            Iterator appPrivs = PermissionService.getDirectPrivileges((OID)appOID, (OID)participant.getOID());
            while (appPrivs.hasNext()) {
                PrivilegeDescriptor priv = (PrivilegeDescriptor)appPrivs.next();
                PermissionService.revokePermission((PermissionDescriptor)new PermissionDescriptor(priv, appOID, participant.getOID()));
            }
        }
    }

    public PartyCollection getParticipants() {
        return new PartyCollection((DataCollection)((DataAssociation)this.get("participants")).cursor());
    }

    public long getParticipantCount() {
        return ((DataAssociation)this.get("participants")).cursor().size();
    }

    public PartyCollection getNonParticipants() {
        DataCollection dc = SessionManager.getSession().retrieve("com.arsdigita.kernel.Party");
        Filter f = dc.addNotInSubqueryFilter("id", PARTICIPANT_ID_QUERY);
        f.set("workspaceID", (Object)this.getID());
        return new PartyCollection(dc);
    }

    public PartyCollection getParticipantsWithInitial(String initial) {
        Assert.assertNotNull((Object)initial);
        Assert.assertTrue((initial.length() == 1 ? 1 : 0) != 0, (String)"Initial needs length 1");
        Assert.assertTrue((boolean)initial.equals(initial.toUpperCase()), (String)"Initial must be uppercase");
        DataAssociationCursor dac = ((DataAssociation)this.get("participants")).cursor();
        Filter f = dac.addInSubqueryFilter("id", "com.arsdigita.workspace.WorkspaceParticipantsWithInitial");
        f.set("workspaceID", (Object)this.getID());
        f.set("nameInitial", (Object)initial);
        return new PartyCollection((DataCollection)dac);
    }

    public Role getMemberRole() {
        if (this.m_memberRole == null) {
            DataAssociation roles = (DataAssociation)this.get("roles");
            DataAssociationCursor rolesCursor = roles.getDataAssociationCursor();
            rolesCursor.addEqualsFilter("type", (Object)"members");
            if (rolesCursor.next()) {
                this.m_memberRole = (Role)DomainObjectFactory.newInstance((DataObject)rolesCursor.getDataObject());
            }
            rolesCursor.close();
        }
        return this.m_memberRole;
    }

    private void setMemberRole(Role role) {
        this.m_memberRole = role;
    }

    public RoleCollection getRoles() {
        return new RoleCollection((DataCollection)((DataAssociation)this.get("roles")).cursor(), this);
    }

    public RoleCollection getDirectRolesFor(Party p) {
        DataAssociationCursor dac = ((DataAssociation)this.get("roles")).cursor();
        if (p instanceof User) {
            Filter f = dac.addInSubqueryFilter("id", "com.arsdigita.workspace.DirectRolesForUser");
            f.set("participantID", (Object)p.getID());
        } else if (p instanceof Group) {
            Filter f = dac.addInSubqueryFilter("id", "com.arsdigita.workspace.DirectRolesForGroup");
            f.set("participantID", (Object)p.getID());
        } else {
            throw new IllegalArgumentException("received party that was neither user nor group");
        }
        return new RoleCollection((DataCollection)dac);
    }

    public RoleCollection getRolesFor(Party p) {
        DataAssociationCursor dac = ((DataAssociation)this.get("roles")).cursor();
        if (p instanceof User) {
            Filter f = dac.addInSubqueryFilter("id", "com.arsdigita.workspace.RolesForUser");
            f.set("participantID", (Object)p.getID());
        } else if (p instanceof Group) {
            Filter f = dac.addInSubqueryFilter("id", "com.arsdigita.workspace.RolesForGroup");
            f.set("participantID", (Object)p.getID());
        } else {
            throw new IllegalArgumentException("received party that was neither user nor group");
        }
        return new RoleCollection((DataCollection)dac);
    }

    public void addPortalTab(PortalTab ptab) {
        this.add("workspaceTab", (DomainObject)ptab);
        this.moveTabToTail(ptab);
    }

    public void removePortalTab(PortalTab ptab) {
        this.remove("workspaceTab", (DomainObject)ptab);
    }

    public PortalTabCollection getTabsForPortalSite() {
        DataAssociation association = (DataAssociation)this.get("workspaceTab");
        if (association == null) {
            return null;
        }
        DataAssociationCursor tabsCursor = association.getDataAssociationCursor();
        tabsCursor.addOrder("sortKey");
        return new PortalTabCollection((DataCollection)tabsCursor);
    }

    public void swapTabWithPrevious(PortalTab ptab) throws PersistenceException {
        int newKey = ptab.getSortKey() - 11;
        ptab.setSortKey(newKey);
        ptab.save();
        this.normalizeTabSortKeys();
    }

    public void swapTabWithNext(PortalTab ptab) throws PersistenceException {
        int newKey = ptab.getSortKey() + 11;
        ptab.setSortKey(newKey);
        ptab.save();
        this.normalizeTabSortKeys();
    }

    public void moveTabToHead(PortalTab ptab) {
        ptab.setSortKey(Integer.MIN_VALUE);
        ptab.save();
        this.normalizeTabSortKeys();
    }

    public void moveTabToTail(PortalTab ptab) {
        ptab.setSortKey(Integer.MAX_VALUE);
        ptab.save();
        this.normalizeTabSortKeys();
    }

    public void normalizeTabSortKeys() {
        PortalTabCollection wtcoll = this.getTabsForPortalSite();
        int index = 10;
        while (wtcoll.next()) {
            PortalTab ptab = wtcoll.getPortalTab();
            ptab.setSortKey(index);
            ptab.save();
            index += 10;
        }
    }

    public boolean isReady() {
        return (Boolean)this.get("isReady");
    }

    public void setReady(boolean isReady) {
        this.set("isReady", new Boolean(isReady));
    }

    public boolean isDraft() {
        return (Boolean)this.get("isDraft");
    }

    public void setDraft(boolean isDraft) {
        this.set("isDraft", new Boolean(isDraft));
    }

    public boolean isPersonalizable() {
        return (Boolean)this.get("isPersonalizable");
    }

    public void setPersonalizable(boolean isPersonalizable) {
        this.set("isPersonalizable", new Boolean(isPersonalizable));
    }

    public boolean isSubPortal() {
        return (Boolean)this.get("isSubPortal");
    }

    public void setIsSubPortal(boolean issubportal) {
        this.set("isSubPortal", new Boolean(issubportal));
    }

    public boolean isArchived() {
        return (Boolean)this.get("isArchived");
    }

    public void setArchived() {
        this.set("isArchived", Boolean.TRUE);
    }

    public void setUnarchived() {
        this.set("isArchived", Boolean.FALSE);
    }

    public void setCreationDate(Date cdate) {
        this.set("creationDate", cdate);
    }

    public void setCreationDate() {
        Calendar rightNow = GregorianCalendar.getInstance();
        Date cdate = rightNow.getTime();
        this.set("creationDate", cdate);
    }

    public Date getCreationDate() {
        return (Date)this.get("creationDate");
    }

    public void setArchiveDate(Date adate) {
        this.set("archiveDate", adate);
    }

    public void setArchiveDate() {
        Calendar rightNow = GregorianCalendar.getInstance();
        Date adate = rightNow.getTime();
        this.set("archiveDate", adate);
    }

    public Date getArchiveDate() {
        return (Date)this.get("archiveDate");
    }

    public void archive() {
        this.setArchived();
        PartyCollection pc = this.getParticipants();
        while (pc.next()) {
            Party p = pc.getParty();
            this.removeParticipant(p);
        }
        this.setArchiveDate();
    }

    public void archiveRecurse() {
        this.archive();
        PortalSiteCollection psc = this.getChildPortalSites();
        psc.filterForUnarchived();
        while (psc.next()) {
            PortalSite portal = psc.getPortalSite();
            portal.archiveRecurse();
        }
    }

    public void unarchive() {
        this.setUnarchived();
        this.setArchiveDate();
    }

    public String getMission() {
        return (String)this.get("mission");
    }

    public void setMission(String mission) {
        this.set("mission", mission);
    }

    public void setTheme(Theme theme) {
        this.set("theme", theme);
    }

    public Theme getTheme() {
        DataObject dobj = (DataObject)this.get("theme");
        if (dobj == null) {
            return null;
        }
        Theme theme = new Theme(dobj);
        return theme;
    }

    public Iterator getParticipantInitials() {
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.workspace.WorkspaceParticipantInitials");
        query.setParameter("workspaceID", (Object)this.getID());
        LinkedList<Object> result = new LinkedList<Object>();
        while (query.next()) {
            result.add(query.get("initial"));
        }
        return result.listIterator();
    }

    public static PortalSite createSubPortal(PortalSite ps, User user) {
        String urlfrag = "U-" + user.getID().toString();
        PortalSite psite = PortalSite.createPortalSite(urlfrag, ps.getDisplayName(), ps);
        psite.setIsSubPortal(true);
        PortalTabCollection ptc = ps.getTabsForPortalSite();
        while (ptc.next()) {
            AgentPortlet aportlet;
            Portlet portlet;
            PortletCollection portletcollection;
            PortalTab ptab = ptc.getPortalTab();
            String layout = ptab.getLayout();
            if (layout == null) continue;
            if (layout.indexOf(119) != -1 || layout.indexOf(110) != -1) {
                portletcollection = ptab.getPortlets();
                for (int i = 0; i < layout.length(); ++i) {
                    if (layout.charAt(i) != 'n' && layout.charAt(i) != 'w') continue;
                    portletcollection.addNotEqualsFilter("cellNumber", (Object)new Integer(i + 1));
                }
                SubPortalTab subtab = SubPortalTab.createSubTab(ptab.getTitle(), (Resource)psite);
                subtab.setSuperPortalTab(ptab);
                subtab.setLayout(ptab.getLayout());
                while (portletcollection.next()) {
                    portlet = portletcollection.getPortlet();
                    aportlet = AgentPortlet.createAgentPortlet((Portlet)portlet, (Resource)subtab, (Portal)subtab);
                    subtab.addPortlet((Portlet)aportlet, portlet.getCellNumber());
                }
                subtab.setPortalSite(psite);
                subtab.save();
                continue;
            }
            portletcollection = ptab.getPortlets();
            PortalTab newtab = PortalTab.createTab(ptab.getTitle(), (Resource)psite);
            newtab.setLayout(ptab.getLayout());
            while (portletcollection.next()) {
                portlet = portletcollection.getPortlet();
                aportlet = AgentPortlet.createAgentPortlet((Portlet)portlet, (Resource)newtab, (Portal)newtab);
                newtab.addPortlet((Portlet)aportlet, portlet.getCellNumber());
            }
            newtab.setPortalSite(psite);
            newtab.save();
        }
        psite.save();
        return psite;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

