/*
 * Copyright (C) 2001, 2003 ArsDigita Corporation. All Rights Reserved.
 *
 * The contents of this file are subject to the ArsDigita Public 
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.arsdigita.com/ADPL.txt
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portlets.rssfeed.installer;

import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;

import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.persistence.SessionManager;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;

import com.arsdigita.bebop.RequestLocal;

import com.arsdigita.portal.Portlet;
import com.arsdigita.portal.PortletSetup;
import com.arsdigita.portal.PortletType;

import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.BaseInitializer;
import com.arsdigita.kernel.ResourceTypeConfig;
import com.arsdigita.kernel.ui.ResourceConfigComponent;
import com.arsdigita.kernel.ui.ResourceConfigFormSection;

import org.apache.log4j.Logger;
import com.arsdigita.util.UncheckedWrapperException;
import java.util.Iterator;
import java.util.List;
import com.arsdigita.util.Assert;

import com.arsdigita.portlets.rssfeed.RSSFeedPortlet;

import com.arsdigita.portlets.rssfeed.ui.RSSFeedPortletEditor;
import com.arsdigita.portlets.rssfeed.ui.RSSFeedPortletEditorForm;


public class Initializer 
    extends BaseInitializer {

    public static final String TYPES = "types";

    private static Logger s_log = Logger.getLogger
        (Initializer.class.getName());


    private Configuration m_conf = new Configuration();

    public Initializer() throws InitializationException {
    }

    public Configuration getConfiguration() {
        return m_conf;
    }

    protected void doStartup() {
        TransactionContext txn = SessionManager.getSession()
            .getTransactionContext();
        
        txn.beginTxn();
        
        loadRSSFeedPortlet();

        txn.commitTxn();
    }


    protected void doShutdown() {
        /* Empty */
    }
    
    private void loadRSSFeedPortlet() {
        PortletSetup setup = new PortletSetup(s_log);
        setup.setPortletObjectType(RSSFeedPortlet.BASE_DATA_OBJECT_TYPE);
        setup.setTitle("RSS Feed");
        setup.setDescription("Displays an RSS Feed");
        setup.setProfile(PortletType.WIDE_PROFILE);
        setup.setInstantiator(new ACSObjectInstantiator() {
            protected DomainObject doNewInstance(DataObject dataObject) {
                return new RSSFeedPortlet(dataObject);
            }
        });
        setup.run();

        new ResourceTypeConfig(RSSFeedPortlet.BASE_DATA_OBJECT_TYPE) {
            public ResourceConfigFormSection getCreateFormSection
                (final ResourceType resType, final RequestLocal parentAppRL) {
                final RSSFeedPortletEditorForm config =
                    new RSSFeedPortletEditorForm(resType, parentAppRL);
                
                return config;
            }
            
            public ResourceConfigFormSection getModifyFormSection
                (final RequestLocal application) {
                final RSSFeedPortletEditorForm config =
                    new RSSFeedPortletEditorForm(application);
                
                return config;
            }

            public ResourceConfigComponent getCreateComponent
                (final ResourceType resType, final RequestLocal parentAppRL) {
                final ResourceConfigComponent config =
                    new RSSFeedPortletEditor(resType, parentAppRL);
                
                return config;
            }
            
            public ResourceConfigComponent getModifyComponent
                (final RequestLocal application) {
                final RSSFeedPortletEditor config =
                    new RSSFeedPortletEditor(application);
                
                return config;
            }
        };

    }
    
}
