/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver.pslogin;

import com.arsdigita.ui.login.SubsiteDispatcher;
import com.arsdigita.kernel.security.Initializer;
import com.arsdigita.bebop.Page;
import java.util.Map;

/**
 * This class extends com.arsdigita.ui.login.SubsiteDispatcher
 * It changes the subsite dispatcher behavior by
 * directing logged-in users to a personal portal
 * rather than the default system portal
 * @author <a href="mailto:bryanche@arsdigita.com">Bryan Che</a>
 **/
public class PSSubsiteDispatcher extends SubsiteDispatcher {

    private static Page s_psPage = new PSPage();

    /**
     * Initializes dispatcher by registering URLs with bebop pages.
     * Replaces the portal mapping from an ACS workspace
     * to a portalserver portal
     **/
    public PSSubsiteDispatcher() {
        super();

        Map map = this.getMap();
        //override the default ACS workspace page
        //with a personal portal page
        put(map, Initializer.WORKSPACE_PAGE_KEY, s_psPage);


        setMap(map);
    }

    /**
     * Adds <url, page> to the given map, where URL is looked up from the
     * page map using the given key.  If the URL represents a directory
     * (ends with "/"), URL+"index" is also added to the map and URL-"/" is
     * redirected to URL.
     **/
    private void put(Map map, String key, Page page) {
        String url = Initializer.getURL(key);
        map.put(url, page);
        if (url.endsWith("/")) {
            map.put(url+"index", page);
            requireTrailingSlash(url.substring(0, url.length()-1));
        }
    }
}
