/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver.personal;


import com.arsdigita.portalserver.util.GlobalizationUtil; 

import com.arsdigita.portalserver.ui.PortalDispatcher;
import com.arsdigita.portalserver.ui.PortalParticipants;
import com.arsdigita.bebop.DimensionalNavbar;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageDispatcher;
import com.arsdigita.portalserver.ui.admin.PortalAdminPage;
import com.arsdigita.dispatcher.Dispatcher;
import com.arsdigita.dispatcher.RequestContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;
import java.util.Map;
import java.util.HashMap;
import java.io.IOException;

/**
 * <p><strong>Experimental</strong></p>
 *
 * @author <a href="mailto:justin@arsdigita.com">Justin Ross</a>
 * @version $Id: //portalserver/dev/src/com/arsdigita/portalserver/personal/PersonalPortalDispatcher.java#4 $
 */
public class PersonalPortalDispatcher extends PortalDispatcher {
    public static final String versionId =
        "$Id: //portalserver/dev/src/com/arsdigita/portalserver/personal/PersonalPortalDispatcher.java#4 $" +
        "$Author: dennis $" +
        "$DateTime: 2003/08/15 13:46:34 $";

    private Dispatcher m_portalAdminDispatcher;

    public PersonalPortalDispatcher() {
        super();

        Map m = new HashMap();

        m.put("", new PersonalPortalHomePage());
        m.put(PORTAL_PARTICIPANT_PAGE, PortalParticipants.createPage());

        setMap(m);
    }

    public void dispatch(HttpServletRequest request,
                         HttpServletResponse response,
                         RequestContext context)
        throws IOException, ServletException {
        String remainingURLPart = context.getRemainingURLPart();

        if (remainingURLPart.startsWith(PORTAL_ADMIN_PAGE)) {
            if (m_portalAdminDispatcher == null) {
                PortalAdminPage page = new PortalAdminPage() {
                        protected void buildContextBar() {
                            DimensionalNavbar navbar = new DimensionalNavbar();

                            navbar.setClassAttr("portalNavbar");

                            navbar.add
                                (new Link(new PersonalPortalLinkPrinter()));
                            navbar.add(new Label(GlobalizationUtil.globalize("cw.workspace.personal.configure_workspace")));

                            getHeader().add(navbar);
                        }
                    };

                m_portalAdminDispatcher = new PageDispatcher(page);
            }

            m_portalAdminDispatcher.dispatch(request, response, context);
        } else {
            super.dispatch(request, response, context);
        }
    }
}
