/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver.personal;


import com.arsdigita.portalserver.util.GlobalizationUtil; 

import com.arsdigita.web.Application;
import com.arsdigita.portal.apportlet.AppPortlet;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.PageState;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;

public class MyPortalsPortlet extends AppPortlet {
    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.workspace.personal.MyWorkspacesPortlet";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public MyPortalsPortlet(DataObject dataObject) {
        super(dataObject);
    }

    protected AbstractPortletRenderer doGetPortletRenderer() {
        return new MyPortalsPortletRenderer(this);
    }

    protected DataQuery getMyPortalsDataQuery(Party party) {
        Assert.assertTrue
            (!isNew(),
             "You must save this portlet before you call " +
             "getMyPortalsDataQuery(User) on it.");

        DataQuery query = SessionManager.getSession().retrieveQuery
            ("com.arsdigita.workspace.personal.MyWorkspaces");

        Assert.assertNotNull(query, "query");

        query.setParameter("userID", party.getID());

        Application parent = getParentApplication();

        Assert.assertNotNull(parent, "parent");

        query.setParameter
            ("personalWorkspaceID", getParentApplication().getID());

        return query;
    }
}

class MyPortalsPortletRenderer extends AbstractPortletRenderer {
    private MyPortalsPortlet m_portlet;

    public MyPortalsPortletRenderer(MyPortalsPortlet portlet) {
        m_portlet = portlet;
    }

    protected void generateBodyXML(PageState pageState, Element parent) {
        Party party = Kernel.getContext().getParty();

        Assert.assertNotNull(party, "party");

        DataQuery query = m_portlet.getMyPortalsDataQuery(party);

        GridPanel panel = new GridPanel(1);

        String title = null;
        String primaryURL = null;
        boolean isEmpty = true;

        while (query.next()) {
            isEmpty = false;

            // id = query.get("id");
            title = (String) query.get("title");
            primaryURL = (String) query.get("primaryURL");

            Assert.assertNotNull(title, "title");
            Assert.assertNotNull(primaryURL, "primaryURL");

            panel.add(new Link(title, primaryURL));
        }

        query.close();

        if (isEmpty) {
            panel.add(new Label(GlobalizationUtil.globalize("cw.workspace.personal.none")));
        }

        panel.generateXML(pageState, parent);
    }
}
