/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver;


import com.arsdigita.portalserver.util.GlobalizationUtil; 

import com.arsdigita.persistence.DataObject;
import com.arsdigita.portal.apportlet.AppPortlet;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.ListPanel;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.xml.Element;
import com.arsdigita.web.URL;

public class PortalSummaryPortlet extends AppPortlet {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/PortalSummaryPortlet.java#7 $ by $Author: dennis $, $DateTime: 2003/08/15 13:46:34 $";

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.workspace.WorkspaceSummaryPortlet";

    private static final int MAX_PARTICIPANTS_FOR_LISTING = 15;

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    // Retrieve.
    public PortalSummaryPortlet(DataObject dataObject) {
        super(dataObject);
    }

    protected AbstractPortletRenderer doGetPortletRenderer() {
        return new PortalSummaryPortletRenderer(this);
    }

    public String getZoomURL() {
        return URL.getDispatcherPath() + getParentApplication().getPrimaryURL() + "participants/";
    }

    private static class PortalSummaryPortletRenderer
        extends AbstractPortletRenderer {
        private PortalSummaryPortlet m_portlet;

        public PortalSummaryPortletRenderer( PortalSummaryPortlet portlet) {
            m_portlet = portlet;
        }

        protected void generateBodyXML(PageState ps, Element parent) {
            PortalSite currentPortal =
                (PortalSite)m_portlet.getParentApplication();

            if (currentPortal == null) {
                return;
            }

            SegmentedPanel main = new SegmentedPanel();

            String mission = currentPortal.getMission();
            if (mission != null) {
                main.addSegment(new Label(GlobalizationUtil.globalize("cw.workspace.mission")), new Label(mission,false));
            }

            PartyCollection pc = currentPortal.getParticipants();
            ListPanel participants = new ListPanel(ListPanel.UNORDERED);

            long participantCount = pc.size();
            if (participantCount > MAX_PARTICIPANTS_FOR_LISTING) {
                DataQuery dq = SessionManager.getSession().retrieveQuery(
                                    "com.arsdigita.workspace.RolesWithCounts");
                dq.setParameter("workspaceID", currentPortal.getID());

                while (dq.next()) {
                    participants.add(new Label(
                             dq.get("roleCount") + " " + dq.get("roleName")));
                }

                participants.add( new Label(participantCount + " " 
                                                 + " Total participants"));
            } else {
                while (pc.next()) {
                    participants.add(new Label(pc.getDisplayName()));
                }
            }

            Link searchLink = new Link( new Label(GlobalizationUtil.globalize("cw.workspace.search_participants")),  "participants/");
            searchLink.addURLVars("action", "search");
            participants.add(searchLink);

            main.addSegment(new Label(GlobalizationUtil.globalize("cw.workspace.participants")), participants);

            main.generateXML(ps, parent);
        }
    }
}
