/*
 * Copyright (C) 2001, 2002 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 */
 
package com.arsdigita.portlets.rssfeed;

import com.arsdigita.populate.portlets.AbstractPopulatePortlet;
import com.arsdigita.populate.portlets.PopulatePortlet;
import com.arsdigita.portal.PortletType;

/**
 * @author bche
 */
public class PopulateRSSFeedPortlet
    extends AbstractPopulatePortlet
    implements PopulatePortlet {

    //use cnet's 5 most recent news items (see http://rss.news.com/) 
    public static final String RSS_URL = "http://rss.com.com/2547-12-0-5.xml";

    /* (non-Javadoc)
     * @see com.arsdigita.populate.portlets.PopulatePortlet#populatePortlet()
     */
    public void populatePortlet() {
        RSSFeedPortlet portlet = (RSSFeedPortlet)getPortlet();
        portlet.setURL(RSS_URL);        
        portlet.save();
    }

    /* (non-Javadoc)
     * @see com.arsdigita.populate.portlets.PopulatePortlet#getPortletType()
     */
    public PortletType getPortletType() {
        return PortletType.retrievePortletTypeForPortlet(RSSFeedPortlet.BASE_DATA_OBJECT_TYPE);
    }

}
