/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver.ui.admin;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.DimensionalNavbar;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;

import com.arsdigita.portalserver.ApplicationPage;
import com.arsdigita.portalserver.PortalSite;

class PortalCreatePage extends ApplicationPage {
    public static final String versionId =
        "$Id: //portalserver/dev/src/com/arsdigita/portalserver/ui/admin/PortalCreatePage.java#3 $" +
        "$Author: dennis $" +
        "$DateTime: 2003/08/15 13:46:34 $";

    public PortalCreatePage() {
        final RequestLocal portalsiteRL = new RequestLocal();

        // TODO: parent portal selection after basic properties entered
        final Component f = PortalCreateForm.
            create(new RequestLocal(), portalsiteRL, new ActionListener() {
              public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                  try {
                    com.arsdigita.dispatcher.DispatcherHelper.sendRedirect(
                    ps.getRequest(), ps.getResponse(),
                    ((PortalSite) portalsiteRL.get(ps)).getSiteNode().getURLNoContext() + "admin/");
                           } catch (java.io.IOException ex) {
                               throw
                                   new com.arsdigita.util.UncheckedWrapperException(ex);
                           }
                       }
                   });

        add(f);

    }

    protected void buildContextBar() {
        DimensionalNavbar navbar = new DimensionalNavbar();
        navbar.setClassAttr("portalNavbar");

        navbar.add(new Link(new PersonalPortalLinkPrinter()));
        navbar.add(new Link(new ParentApplicationLinkPrinter()));
        navbar.add(new Label(new CurrentApplicationLabelPrinter()));

        getHeader().add(navbar);
    }

}
