/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver.ui;

import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageDispatcher;
import com.arsdigita.bebop.BebopMapDispatcher;
import com.arsdigita.portalserver.ui.admin.PortalAdminPage;
import com.arsdigita.dispatcher.Dispatcher;
import com.arsdigita.dispatcher.RequestContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;
import java.util.Map;
import java.util.HashMap;
import java.io.IOException;
import org.apache.log4j.Logger;

/**
 * <p><strong>Experimental</strong></p>
 *
 * @author <a href="mailto:justin@arsdigita.com">Justin Ross</a>
 * @version $Id: //portalserver/dev/src/com/arsdigita/portalserver/ui/PortalDispatcher.java#4 $
 */
public class PortalDispatcher extends BebopMapDispatcher {
    public static final String versionId =
        "$Id: //portalserver/dev/src/com/arsdigita/portalserver/ui/PortalDispatcher.java#4 $" +
        "$Author: dennis $" +
        "$DateTime: 2003/08/15 13:46:34 $";

    private static final Logger s_log = Logger.getLogger
        (PortalDispatcher.class);

    // XXX Move these to constant pool.

    protected static final String PORTAL_HOME_PAGE = "index.xhtml";
    protected static final String PORTAL_ADMIN_PAGE = "admin";
    protected static final String PORTAL_PARTICIPANT_PAGE = "participants";

    private Dispatcher m_portalsiteAdminDispatcher;

    public PortalDispatcher() {
        super();

        Page portalHomePage = new PortalHomePage();

        Map m = new HashMap();
        m.put("", portalHomePage);
        m.put(PORTAL_HOME_PAGE, portalHomePage);
        m.put(PORTAL_PARTICIPANT_PAGE, PortalParticipants.createPage());
        setMap(m);
    }

    public void dispatch(HttpServletRequest request,
                         HttpServletResponse response,
                         RequestContext context)
        throws IOException, ServletException {
        String remainingURLPart = context.getRemainingURLPart();


        if (s_log.isDebugEnabled()) {
            s_log.debug("Remaining URL part is '" + remainingURLPart + "'");
        }

        if (remainingURLPart.startsWith(PORTAL_ADMIN_PAGE)) {
            if (m_portalsiteAdminDispatcher == null) {
                m_portalsiteAdminDispatcher =
                    new PageDispatcher(new PortalAdminPage());
            }

            m_portalsiteAdminDispatcher.dispatch(request, response, context);
        } else {
            super.dispatch(request, response, context);
        }
    }
}
