/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver.personal;

import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.web.Application;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.kernel.User;
import com.arsdigita.util.Assert;

/**
 * <p><strong>Experimental</strong></p>
 *
 * @author <a href="mailto:justin@arsdigita.com">Justin Ross</a>
 * @version $Id: //portalserver/dev/src/com/arsdigita/portalserver/personal/PersonalPortal.java#4 $
 */
public class PersonalPortal extends PortalSite {
    public static final String versionId =
        "$Id: //portalserver/dev/src/com/arsdigita/portalserver/personal/PersonalPortal.java#4 $" +
        "$Author: dennis $" +
        "$DateTime: 2003/08/15 13:46:34 $";

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.workspace.personal.PersonalWorkspace";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    protected PersonalPortal(DataObject dataObject) {
        super(dataObject);
    }

    public static PersonalPortal createPersonalPortal
                           (User user, Application parent) {
        Assert.assertNotNull(user, "user");

        PersonalPortal portal = (PersonalPortal)
            Application.createApplication
            (BASE_DATA_OBJECT_TYPE, user.getID().toString(),
             "Personal Portal", parent);

        portal.setOwningUser(user);

        return portal;
    }

    public static PersonalPortal createPersonalPortal(User user) {
        Application parent = Application.retrieveApplicationForPath
            ("/personal-portal/");

        Assert.assertNotNull(parent, "parent");

        return PersonalPortal.createPersonalPortal(user, parent);
    }

    // Can return null.
    public static PersonalPortal retrievePersonalPortal(User user) {
        DataCollection portals = SessionManager.getSession().retrieve
            (BASE_DATA_OBJECT_TYPE);

        portals.addEqualsFilter("user.id", user.getID());

        PersonalPortal portal = null;

        if (portals.next()) {
            portal = (PersonalPortal) Application.retrieveApplication
                (portals.getDataObject());
        }

        portals.close();

        return portal;
    }

    private void setOwningUser(User user) {
        Assert.assertNotNull(user, "user");

        setAssociation("user", user);
    }

    public User getOwningUser() {
        DataObject dataObject = (DataObject) get("user");

        Assert.assertNotNull(dataObject, "dataObject");

        return User.retrieve(dataObject);
    }
}
