/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver.permissions;

import java.util.*;
import com.arsdigita.bebop.parameters.*;
import com.arsdigita.bebop.form.*;
import com.arsdigita.bebop.*;
import com.arsdigita.bebop.event.*;
import com.arsdigita.xml.Element;
import com.arsdigita.persistence.metadata.ObjectType;


class TypeSingleSelect extends SingleSelect {
    private RequestLocal m_typesRL;

    public TypeSingleSelect(ParameterModel param,
                            RequestLocal typesRL) {
        super(param);

        m_typesRL = typesRL;

        addOption(new Option(AddGrantForm.ALL_TYPES,
                             "All Contained Items"));
        setPrintListener(new PrintListener() {
                public void prepare(PrintEvent ev) {
                    SingleSelect tgt = (SingleSelect)ev.getTarget();
                    PageState ps = ev.getPageState();
                    Iterator types =
                        ((Collection)m_typesRL.get(ps)).iterator();
                    while (types.hasNext()) {
                        ObjectType type = (ObjectType)types.next();
                        tgt.addOption(new Option(type.getQualifiedName(),
                                                 type.getName()));
                    }
                }
            });
    }

    public void generateXML(PageState ps, Element parent) {
        Collection types = (Collection)m_typesRL.get(ps);
        if (types == null) {
            parent.newChildElement("bebop:label", BEBOP_XML_NS);
            return;
        } else {
            super.generateXML(ps, parent);
        }
    }
}
