/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver;

import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.GroupCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataCollection;

public class RoleCollection extends GroupCollection {

    private PortalSite m_portalsite;

    protected RoleCollection(DataCollection dc, PortalSite p) {
        super(dc);
        m_portalsite = p;
    }

    public RoleCollection(DataCollection dc) {
        super(dc);
    }

    public String getRoleName() {
        return (String) m_dataCollection.get("roleName");
    }

    public boolean isSystem() {
        return ((Boolean) m_dataCollection.get("isSystem")).booleanValue();
    }

    public PortalSite getPortalSite() {
        if (m_portalsite == null) {
            return (PortalSite) DomainObjectFactory.newInstance(
                              (DataObject) m_dataCollection.get("workspace"));
        } else {
            return m_portalsite;
        }
    }

    public Role getRole() {
        return (Role)getDomainObject();
    }
}
