/*
 * Copyright (C) 2001, 2003 ArsDigita Corporation. All Rights Reserved.
 *
 * The contents of this file are subject to the ArsDigita Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.arsdigita.com/ADPL.txt
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver;

import com.arsdigita.web.Application;
import com.arsdigita.web.BaseApplicationServlet;
import com.arsdigita.portalserver.ui.PortalHomePage;
import com.arsdigita.portalserver.ui.PortalParticipants;
import com.arsdigita.portalserver.ui.admin.PortalAdminPage;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.sitenode.BasePresentationManager;
import com.arsdigita.templating.PresentationManager;
import com.arsdigita.templating.Templating;
import com.arsdigita.bebop.Page;
import com.arsdigita.xml.Document;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

/**
 *
 * @author Justin Ross &lt;<a href="mailto:jross@redhat.com">jross@redhat.com</a>&gt;
 */
public class PortalServlet extends BaseApplicationServlet {
    public static final String versionId =
        "$Id: //portalserver/dev/src/com/arsdigita/portalserver/PortalServlet.java#6 $" +
        "$Author: dennis $" +
        "$DateTime: 2003/08/15 13:46:34 $";

    private static final Logger s_log = Logger.getLogger
        (PortalServlet.class);

    private static final PresentationManager s_presManager =
        Templating.getPresentationManager();

    private static Page s_homePage = new PortalHomePage();
    private static Page s_particPage = PortalParticipants.createPage();
    private static Page s_adminPage = null;

    static {
        TransactionContext ctx = SessionManager.getSession().getTransactionContext();
        ctx.beginTxn();

        s_adminPage = new PortalAdminPage();

        ctx.commitTxn();
    }

    public void doService(HttpServletRequest sreq,
                          HttpServletResponse sresp,
                          Application app)
            throws ServletException, IOException {
        s_log.debug("PortalServlet.doService called for request '" +
                    sreq.getRequestURI() + "'");

        String path = sreq.getServletPath();
        Document doc = null;

        if (path.endsWith("participants")) {
            doc = s_particPage.buildDocument(sreq, sresp);
        } else if (path.endsWith("admin")) {
            doc = s_adminPage.buildDocument(sreq, sresp);
        } else {
            doc = s_homePage.buildDocument(sreq, sresp);
        }

        s_presManager.servePage(doc, sreq, sresp);
    }
}
