/*
 * Copyright (C) 2001, 2003 ArsDigita Corporation. All Rights Reserved.
 *
 * The contents of this file are subject to the ArsDigita Public 
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.arsdigita.com/ADPL.txt
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portlets.timeofday.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.xml.Element;
import com.arsdigita.portal.Portlet;
import java.util.Date;
import com.arsdigita.portlets.timeofday.TimeOfDayPortlet;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;


public class TimeOfDayPortletRenderer extends AbstractPortletRenderer {
    private TimeOfDayPortlet m_portlet;
    
    public TimeOfDayPortletRenderer(TimeOfDayPortlet portlet) {
        m_portlet = portlet;
    }

    public void generateBodyXML(PageState state,
                                Element parent) {
        Element date = parent.newChildElement("portlet:timeOfDay",
                                       "http://www.arsdigita.com/portlet/1.0");
        date.addAttribute("date", (new Date()).toString());
    }
}
