/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver.ui.admin;

import com.arsdigita.portalserver.*;
import com.arsdigita.bebop.parameters.*;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.parameters.ParameterData;



public class UniquePortalURLValidationListener implements ParameterListener {

    public UniquePortalURLValidationListener() {
    }

    public void validate(ParameterEvent e)
        throws FormProcessException {

        ParameterData d = e.getParameterData();
        String value = (String)d.getValue();


        //URLs are stored in DB with leading and trailing slash...make 
        //sure this URL has them
        if(!(value.endsWith("/")))
            value += "/";
        if(!(value.startsWith("/")))
            value = "/" + value;

            PortalSiteCollection pc = PortalSite.retrieveAllPortalSites();
            pc.addEqualsFilter("primaryURL",value);
            if(pc.next())
              {
                d.invalidate();
                d.addError("Please enter a different URL -- this one has been used");
              }
            pc.close();
    }
}
