/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver.personal;

import com.arsdigita.portalserver.PortalTab;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.ResourceTypeConfig;
import com.arsdigita.web.Application;
import com.arsdigita.portal.Portlet;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.util.Assert;

/**
 * <p><strong>Experimental</strong></p>
 *
 * @author <a href="mailto:justin@arsdigita.com">Justin Ross</a>
 * @version $Id: //portalserver/dev/src/com/arsdigita/portalserver/personal/PersonalPortalConfig.java#3 $
 */
public class PersonalPortalConfig extends ResourceTypeConfig {
    public PersonalPortalConfig() {
        super();

        ResourceType.registerResourceTypeConfig
            (PersonalPortal.BASE_DATA_OBJECT_TYPE, this);
    }

    public void configureApplication(Application application) {
        Assert.assertTrue(application instanceof PersonalPortal);

        PersonalPortal portal = (PersonalPortal) application;

        // PortalSite/Portal save ordering is in a disturbing state.
        portal.save();

        // Portlets

        PortalTab tab = PortalTab.createTab("Main");

        Portlet portlet = null;

        portlet = Portlet.createPortlet
            (MyPortalsPortlet.BASE_DATA_OBJECT_TYPE, portal);
        tab.addPortlet(portlet, 1);

        tab.setPortalSite(portal);
        tab.save();

        portal.addPortalTab(tab);
        portal.addMember(portal.getOwningUser());

        portal.save();

        // Permissions

        PermissionDescriptor perm = new PermissionDescriptor
            (PrivilegeDescriptor.ADMIN, portal, portal.getOwningUser());
        PermissionService.grantPermission(perm);
    }
}
