/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver;


import com.arsdigita.portalserver.util.GlobalizationUtil; 

import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.DimensionalNavbar;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.web.Application;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.portalserver.personal.PersonalPortal;
import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;

/**
 * <p>ToolPage class</p>
 *
 * <p>This is a common page to be used by all applications for
 * consistent styling.</p>
 *
 * @author <a href="mailto:teadams@arsdigita.com">Tracy Adams</a>
 * @version $Revision: #4 $ $Date: 2003/08/15 $
 */

/* XXX Have to control links with permissions and
 *      add access control
 */
public class ToolPage extends PortalPage {
    public static final String versionId =
        "$Id: //portalserver/dev/src/com/arsdigita/portalserver/ToolPage.java#4 $" +
        "$Author: dennis $" +
        "$DateTime: 2003/08/15 13:46:34 $";

    private static final Logger s_log = Logger.getLogger(ToolPage.class);

    /*
     * There are 2 views: user and admin.
     * m_view determines which context bar and
     * view link to show.
     */
    private String m_view;

    private Link m_viewLink;

    public ToolPage() {
        this(null);
    }

    /**
     * @param view A String that specifies which application view to
     * show.  Valid values: "user", "admin" and "null".  If view is
     * "null", there will be no right-hand navigation link.  Note -
     * We've decided not to have the right-hand navigation link at
     * all. Instead, you should create tabs.  So, once the
     * applications are migrated, view will always be null and we can
     * remove view altogether.
     */
    public ToolPage(String view) {
        super();

        m_view = view;
    }

    protected void buildContextBar() {
        DimensionalNavbar navbar = new DimensionalNavbar();

        navbar.setClassAttr("portalNavbar");

        navbar.add(new LoggedInLinkWrapper(new PersonalPortalLinkPrinter()));

        // This link will not show up if the current workspace is a
        // personal portal.
        Link current = new Link(new CurrentPortalLinkPrinter()) {
                public boolean isVisible(PageState state) {
                    PortalSite psite = PortalSite.getCurrentPortalSite
                        (state.getRequest());

                    return !(psite instanceof PersonalPortal);
                }
            };
        navbar.add(current);

        if (m_view != null && m_view.equals("admin")) {
            navbar.add(new Link(new CurrentApplicationLinkPrinter()) {
                    public boolean isVisible(PageState ps) {
                        return userIsAdmin(ps);
                    }});
            navbar.add(new Label(GlobalizationUtil.globalize("cw.workspace.administration")) {
                    public boolean isVisible(PageState ps) {
                        return userIsAdmin(ps);
                    }});
        } else {
            navbar.add(new Label(new CurrentApplicationLabelPrinter()));
        }

        getHeader().add(navbar);
    }

    protected void buildTitle() {
        class ApplicationAdminLabelPrinter implements PrintListener {
            public void prepare(PrintEvent e) {
                Label targetLabel = (Label)e.getTarget();
                PageState pageState = e.getPageState();

                Application application = Application.getCurrentApplication
                    (pageState.getRequest());

                Assert.assertNotNull(application, "application");

                targetLabel.setLabel
                    (application.getTitle() + " Administration");
            }
        }

        if (m_view != null && m_view.equals("admin")) {
            setTitle(new Label(new ApplicationAdminLabelPrinter()));
        } else {
            setTitle(new Label(new CurrentApplicationLabelPrinter()));
        }
    }

    protected void buildHeader(Container header) {
        if (m_view != null) {
            if (m_view.equals("user")) {
                m_viewLink = new Link
                    ("Administration view", "./admin/index.jsp") {
                        public boolean isVisible(PageState ps) {
                            return userIsAdmin(ps);
                        }};
            } else if (m_view.equals("admin")) {
                m_viewLink = new Link( new Label(GlobalizationUtil.globalize("cw.workspace.user_view")),  "../index.jsp");
            }
        }

        if (m_viewLink != null) {
            m_viewLink.setClassAttr("portalControl");

            header.add(m_viewLink);
        }
    }

    private boolean userIsAdmin(PageState ps) {
        PermissionDescriptor permDescriptor =
            new PermissionDescriptor(PrivilegeDescriptor.ADMIN,
                                     Application.getCurrentApplication(ps.getRequest()),
                                     Kernel.getContext().getParty());
        return PermissionService.checkPermission(permDescriptor);
    }
}
