/*
 * Copyright (C) 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver;

import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.kernel.Kernel;

/**
 * Wraps a Link so that it becomes invisible if
 * there is no user logged in.
 */
public class LoggedInLinkWrapper extends Link {

    public LoggedInLinkWrapper(PrintListener l) {
        super(l);
    }

    public boolean isVisible(PageState state) {
        if ( Kernel.getContext().getParty() == null ) {
            return false;
        } else {
            return true;
        }
    }

}
