/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver;


import com.arsdigita.portalserver.util.GlobalizationUtil;

import com.arsdigita.web.*;
import com.arsdigita.persistence.*;
import com.arsdigita.persistence.metadata.*;
import com.arsdigita.domain.*;
import com.arsdigita.kernel.*;
import java.util.*;
import java.net.URLEncoder;
import javax.servlet.http.HttpUtils;

/**
 * <font color="red">Experimental</font>
 *
 * A URLFinder that can be registered for most object types.  The
 * CWURLFinder is constructed with a specified URL pattern such
 * as <code>one-ticket?ticket_id=:id</code>.
 *
 * @author Oumi Mehrotra (oumi@arsdigita.com)
 **/
public class CWURLFinder implements URLFinder {

    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/CWURLFinder.java#5 $ by $Author: scott $, $DateTime: 2004/01/20 11:45:10 $";

    private String m_base;
    private Map m_params;

    public CWURLFinder(String urlEndingPattern) {
        m_params = new HashMap();
        m_base = parseQueryString(urlEndingPattern, m_params);
        // setFormat(urlEndingPattern);
    }

    public String find(OID oid, String context) throws NoValidURLException {
        return find(oid);
    }

    public String find(OID oid) throws NoValidURLException {
        ACSObject obj;

        try {
            obj = (ACSObject) DomainObjectFactory.newInstance(oid);
        } catch (DataObjectNotFoundException e) {
            throw new NoValidURLException("No such data object: " + oid);
        }

        if (obj instanceof Application) {
            return ((Application) obj).getPrimaryURL();
        } else {
            Application app = Application.getContainingApplication(obj);
            if (app == null) {
                throw new NoValidURLException(
                             "Could not find application instance for " + obj);
            }
            return app.getPrimaryURL() + m_base + unparseQueryString(oid);
        }
    }

    /**
     * Copied from com.arsdigita.util.URLRewriter and modified slightly.
     **/
    private String unparseQueryString(OID oid) {
        StringBuffer buf = new StringBuffer(128);
        char sep = '?';
        Iterator keys = m_params.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = m_params.get(key);
            if (value instanceof String[]) {
                String[] values = (String[])value;
                for (int i = 0; i < values.length; i++) {
                    if (values[i] != null) {
                        appendParam(buf, sep, key, getValue(oid, values[i]));
                        sep = '&';
                    }
                }
                continue;
            } else if (value != null) {
                appendParam(buf, sep, key, getValue(oid, value.toString()));
                sep = '&';
            }
        }
        return buf.toString();
    }

    private String getValue(OID oid, String val) {
        if (val.equals(":oid")) {
            return oid.toString();
        } else if (val.charAt(0)==':') {
            return oid.get(val.substring(1)).toString();
        }
        return val;
    }

    //
    // COPIED FROM: com.arsdigita.util.URLRewriter
    //

    private static String parseQueryString(String url, Map params) {
        int qmark = url.indexOf('?');
        if (qmark < 0) {
            return url;
        }
        String base = url.substring(0, qmark);
        String query = url.substring(qmark+1);
        params.putAll(HttpUtils.parseQueryString(query));
        return base;
    }

    /**
     * Appends string representation of a parameter to the given
     * StringBuffer: sep + URLEncode(key) + '=' + URLEncode(value)
     **/
    private static void appendParam(StringBuffer buf, char sep,
                                    String key, String value) {
        buf.append(sep).append(URLEncoder.encode(key))
            .append('=').append(URLEncoder.encode(value));
    }

}
