/*
 * Copyright (C) 2001, 2003 ArsDigita Corporation. All Rights Reserved.
 *
 * The contents of this file are subject to the ArsDigita Public 
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.arsdigita.com/ADPL.txt
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portlets.freeform.installer;

import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;

import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.persistence.SessionManager;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;

import com.arsdigita.bebop.RequestLocal;

import com.arsdigita.portal.Portlet;
import com.arsdigita.portal.PortletSetup;
import com.arsdigita.portal.PortletType;

import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.BaseInitializer;
import com.arsdigita.kernel.ResourceTypeConfig;
import com.arsdigita.kernel.ui.ResourceConfigComponent;
import com.arsdigita.kernel.ui.ResourceConfigFormSection;

import org.apache.log4j.Logger;
import com.arsdigita.util.UncheckedWrapperException;
import java.util.Iterator;
import java.util.List;
import com.arsdigita.util.Assert;

import com.arsdigita.portlets.freeform.FreeformHTMLPortlet;

import com.arsdigita.portlets.freeform.ui.FreeformHTMLPortletEditor;


public class Initializer 
    extends BaseInitializer {

    public static final String TYPES = "types";

    private static Logger s_log = Logger.getLogger
        (Initializer.class.getName());


    private Configuration m_conf = new Configuration();

    public Initializer() throws InitializationException {
    }

    public Configuration getConfiguration() {
        return m_conf;
    }

    protected void doStartup() {
        TransactionContext txn = SessionManager.getSession()
            .getTransactionContext();
        
        txn.beginTxn();
        
        loadFreeformHTMLPortlet();

        txn.commitTxn();
    }


    protected void doShutdown() {
        /* Empty */
    }
    
    private void loadFreeformHTMLPortlet() {
        PortletSetup setup = new PortletSetup(s_log);
        setup.setPortletObjectType(FreeformHTMLPortlet.BASE_DATA_OBJECT_TYPE);
        setup.setTitle("Freeform HTML");
        setup.setDescription("Displays a freeform block of HTML");
        setup.setProfile(PortletType.WIDE_PROFILE);
        setup.setInstantiator(new ACSObjectInstantiator() {
            protected DomainObject doNewInstance(DataObject dataObject) {
                return new FreeformHTMLPortlet(dataObject);
            }
        });
        setup.run();

        new ResourceTypeConfig(FreeformHTMLPortlet.BASE_DATA_OBJECT_TYPE) {
            public ResourceConfigFormSection getCreateFormSection
                (final ResourceType resType, final RequestLocal parentAppRL) {
                final ResourceConfigFormSection config =
                    new FreeformHTMLPortletEditor(resType, parentAppRL);
                
                return config;
            }
            
            public ResourceConfigFormSection getModifyFormSection
                (final RequestLocal application) {
                final FreeformHTMLPortletEditor config =
                    new FreeformHTMLPortletEditor(application);
                
                return config;
            }
        };

    }
    
}
