/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.pslogin;

import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.Resource;
import com.arsdigita.kernel.ResourceTypeConfig;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.security.Initializer;
import com.arsdigita.persistence.OID;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.personal.PersonalPortal;
import com.arsdigita.util.Assert;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class PSPageRequestListener
implements RequestListener {
    PSPageRequestListener() {
    }

    public void pageRequested(RequestEvent e) {
        String sUrl = "";
        Party party = Kernel.getContext().getParty();
        if (party == null) {
            sUrl = Initializer.getURL((String)Initializer.LOGIN_PAGE_KEY);
        } else {
            try {
                User user = User.retrieve((OID)party.getOID());
                PortalSite psite = PersonalPortal.retrievePersonalPortal(user);
                if (psite == null) {
                    psite = this.setupPersonalPortal(user);
                }
                sUrl = psite.getPrimaryURL();
            }
            catch (DataObjectNotFoundException donfe) {
                sUrl = Initializer.getURL((String)Initializer.LOGIN_PAGE_KEY);
            }
        }
        try {
            DispatcherHelper.sendRedirect((HttpServletRequest)e.getPageState().getRequest(), (HttpServletResponse)e.getPageState().getResponse(), (String)sUrl);
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    private PortalSite setupPersonalPortal(final User u) {
        final PortalSite[] m_psite = new PortalSite[]{null};
        KernelExcursion rootExcursion = new KernelExcursion(){

            public void excurse() {
                this.setParty(Kernel.getSystemParty());
                PersonalPortal psite = PersonalPortal.createPersonalPortal(u);
                Assert.assertNotNull((Object)((Object)psite), (String)"workspace");
                ResourceTypeConfig config = psite.getApplicationType().getConfig();
                Assert.assertNotNull((Object)config, (String)"config");
                config.configureResource((Resource)psite);
                psite.save();
                PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)psite, (Party)u));
                m_psite[0] = psite;
            }
        };
        rootExcursion.run();
        return m_psite[0];
    }
}

