/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.personal;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.portal.apportlet.AppPortletSetup;
import com.arsdigita.portalserver.personal.MyPortalsPortlet;
import com.arsdigita.portalserver.personal.PersonalPortal;
import com.arsdigita.portalserver.personal.PersonalPortalConfig;
import com.arsdigita.portalserver.personal.PersonalPortalCreator;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationSetup;
import com.arsdigita.web.ApplicationType;
import org.apache.log4j.Category;

public class Initializer
implements com.arsdigita.initializer.Initializer {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/personal/Initializer.java#11 $$Author: bche $$DateTime: 2003/10/07 11:20:18 $";
    private static Category s_log = Category.getInstance((Class)(class$com$arsdigita$portalserver$personal$Initializer == null ? (class$com$arsdigita$portalserver$personal$Initializer = Initializer.class$("com.arsdigita.portalserver.personal.Initializer")) : class$com$arsdigita$portalserver$personal$Initializer));
    private Configuration m_conf = new Configuration();
    static /* synthetic */ Class class$com$arsdigita$portalserver$personal$Initializer;

    public Configuration getConfiguration() {
        return this.m_conf;
    }

    public void startup() {
        s_log.info((Object)"Initializing Personal Portal...");
        TransactionContext txn = SessionManager.getSession().getTransactionContext();
        txn.beginTxn();
        ApplicationType creatorAppType = this.setupPersonalPortalCreatorApplication();
        boolean creatorInstalled = Application.isInstalled((String)"com.arsdigita.workspace.personal.PersonalWorkspaceCreator", (String)"/personal-portal/");
        if (!creatorInstalled) {
            KernelExcursion ex = new KernelExcursion(){

                protected void excurse() {
                    this.setParty(Kernel.getSystemParty());
                    Application creatorApp = Application.createApplication((String)"com.arsdigita.workspace.personal.PersonalWorkspaceCreator", (String)"personal-portal", (String)"Personal Portal Creator", null);
                    creatorApp.save();
                }
            };
            ex.run();
        }
        ApplicationType pwAppType = this.setupPersonalPortalApplication();
        this.setupMyPortalsPortlet();
        txn.commitTxn();
        s_log.info((Object)"Done initializing Personal Portal.");
    }

    private ApplicationType setupPersonalPortalCreatorApplication() {
        ApplicationSetup setup = new ApplicationSetup(s_log);
        setup.setApplicationObjectType("com.arsdigita.workspace.personal.PersonalWorkspaceCreator");
        setup.setKey("personal-portal-creator");
        setup.setTitle("Personal Portal Creator");
        setup.setDescription("Responsible for creating personal portals.");
        setup.setStylesheet("/packages/portalserver/xsl/portalserver.xsl");
        setup.setDispatcherClass("com.arsdigita.portalserver.personal.PersonalPortalCreatorDispatcher");
        setup.setPortalApplication(false);
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            protected DomainObject doNewInstance(DataObject dataObject) {
                return new PersonalPortalCreator(dataObject);
            }
        });
        return setup.run();
    }

    private ApplicationType setupPersonalPortalApplication() {
        ApplicationSetup setup = new ApplicationSetup(s_log);
        setup.setApplicationObjectType("com.arsdigita.workspace.personal.PersonalWorkspace");
        setup.setKey("personal-portal");
        setup.setTitle("Personal Portal");
        setup.setDescription("A portal for an individual.");
        setup.setStylesheet("/packages/portalserver/xsl/portalserver.xsl");
        setup.setDispatcherClass("com.arsdigita.portalserver.personal.PersonalPortalDispatcher");
        setup.setPortalApplication(false);
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            protected DomainObject doNewInstance(DataObject dataObject) {
                return new PersonalPortal(dataObject);
            }
        });
        ApplicationType type = setup.run();
        new PersonalPortalConfig();
        return type;
    }

    private void setupMyPortalsPortlet() {
        AppPortletSetup setup = new AppPortletSetup(s_log);
        setup.setPortletObjectType("com.arsdigita.workspace.personal.MyWorkspacesPortlet");
        setup.setTitle("My Portals");
        setup.setDescription("Displays links to portals to which you belong.");
        setup.setProfile("narrow");
        setup.setPortalApplication(true);
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new MyPortalsPortlet(dataObject);
            }
        });
        setup.run();
    }

    public void shutdown() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

