/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.admin;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.initializer.Configuration;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.portalserver.admin.PSAdmin;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationSetup;
import com.arsdigita.web.ApplicationType;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public class Initializer
implements com.arsdigita.initializer.Initializer {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/admin/Initializer.java#8 $ by $Author: bche $, $DateTime: 2003/10/07 11:20:18 $";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$portalserver$admin$Initializer == null ? (class$com$arsdigita$portalserver$admin$Initializer = Initializer.class$("com.arsdigita.portalserver.admin.Initializer")) : class$com$arsdigita$portalserver$admin$Initializer));
    private Configuration m_conf = new Configuration();
    static /* synthetic */ Class class$com$arsdigita$portalserver$admin$Initializer;

    public Configuration getConfiguration() {
        return this.m_conf;
    }

    public void startup() {
        s_log.info((Object)"Initializing PortalServer Admin...");
        TransactionContext txn = SessionManager.getSession().getTransactionContext();
        txn.beginTxn();
        ApplicationSetup setup = new ApplicationSetup((Category)s_log);
        setup.setApplicationObjectType("com.arsdigita.admin.CWAdmin");
        setup.setTitle("Portal Server Site Administration");
        setup.setDescription("Displays common administration tasks.");
        setup.setPortalApplication(false);
        setup.setKey("portal-admin");
        setup.setStylesheet("/packages/portalserver/xsl/portalserver.xsl");
        setup.setDispatcherClass("com.arsdigita.portalserver.admin.ui.Dispatcher");
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            protected DomainObject doNewInstance(DataObject dataObject) {
                return new PSAdmin(dataObject);
            }
        });
        this.setupAdminInstance(setup.run());
        txn.commitTxn();
        s_log.info((Object)"Done initializing PortalServer Admin.");
    }

    private void setupAdminInstance(final ApplicationType type) {
        if (!Application.isInstalled((String)"com.arsdigita.admin.CWAdmin", (String)"/portal-admin/")) {
            s_log.info((Object)"There is no Portal Admin application instance on /portal-admin/.  Installing now.");
            KernelExcursion ex = new KernelExcursion(){

                protected void excurse() {
                    this.setParty(Kernel.getSystemParty());
                    Application app = Application.createApplication((ApplicationType)type, (String)"portal-admin", (String)"Site Administration", null);
                    app.save();
                }
            };
            ex.run();
            s_log.info((Object)"Done installing Portal Admin on /portal-admin/.");
        }
    }

    public void shutdown() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

