/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.Resource;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.DataQueryDataCollectionAdapter;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.portal.Portal;
import com.arsdigita.portal.PortletCollection;
import com.arsdigita.portalserver.PortalTab;
import com.arsdigita.util.Assert;
import java.util.ArrayList;

public class SubPortalTab
extends PortalTab {
    private static final int SORT_KEY_JUMP = 10;
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.workspace.SubWorkspaceTab";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public SubPortalTab(DataObject dataObject) {
        super(dataObject);
    }

    public static SubPortalTab createSubTab(String title, Resource parent) {
        SubPortalTab ptab = (SubPortalTab)Portal.create((String)BASE_DATA_OBJECT_TYPE, (String)title, (Resource)parent);
        ptab.setSortKey(0);
        return ptab;
    }

    public static SubPortalTab createSubTab(String title) {
        SubPortalTab ptab = (SubPortalTab)Portal.create((String)BASE_DATA_OBJECT_TYPE, (String)title, null);
        ptab.setSortKey(0);
        return ptab;
    }

    public PortletCollection getPortlets() {
        PortalTab ptab = this.getSuperPortalTab();
        if (ptab == null) {
            String thislayout = this.getLayout();
            this.setLayout(thislayout.toUpperCase());
            return super.getPortlets();
        }
        String layout = ptab.getLayout();
        ArrayList<Integer> l = new ArrayList<Integer>();
        boolean found_one = false;
        for (int i = 0; i < layout.length(); ++i) {
            char c = layout.charAt(i);
            if (c != 'n' && c != 'w') continue;
            l.add(new Integer(i));
            found_one = true;
        }
        if (found_one) {
            Session session = SessionManager.getSession();
            DataQuery query = session.retrieveQuery("com.arsdigita.workspace.getSubPortalPortlets");
            query.setParameter("subPortalTabID", (Object)this.getID());
            query.setParameter("cells", l);
            DataQueryDataCollectionAdapter dc = new DataQueryDataCollectionAdapter(query, "portlet");
            PortletCollection pc = new PortletCollection((DataCollection)dc);
            return pc;
        }
        return super.getPortlets();
    }

    public void setSuperPortalTab(PortalTab ptab) {
        this.setAssociation("workspaceTab", (DomainObject)ptab);
    }

    public PortalTab getSuperPortalTab() {
        DataObject dataObject = (DataObject)this.get("workspaceTab");
        Assert.assertNotNull((Object)dataObject, (String)"dataObject");
        return new PortalTab(dataObject);
    }
}

