/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.populate.portalserver;

import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserCollection;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.populate.Utilities;
import com.arsdigita.populate.apps.PopulateAppPairCollection;
import com.arsdigita.populate.apps.PopulateApps;
import com.arsdigita.populate.portlets.PopulatePortletCollection;
import com.arsdigita.populate.portlets.PopulatePortlets;
import com.arsdigita.portal.Portal;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.PortalTab;
import com.arsdigita.portalserver.PortalTabCollection;
import com.arsdigita.web.Application;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class PopulatePortalSites {
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$populate$portalserver$PopulatePortalSites == null ? (class$com$arsdigita$populate$portalserver$PopulatePortalSites = PopulatePortalSites.class$("com.arsdigita.populate.portalserver.PopulatePortalSites")) : class$com$arsdigita$populate$portalserver$PopulatePortalSites));
    private PopulateAppPairCollection m_popAppPairs = null;
    private PopulatePortletCollection m_popPortlets = null;
    private String m_sBaseStringSeed = null;
    static /* synthetic */ Class class$com$arsdigita$populate$portalserver$PopulatePortalSites;

    public PopulatePortalSites(PopulateAppPairCollection popAppPairs, PopulatePortletCollection popPortlets) {
        this.m_popAppPairs = popAppPairs;
        this.m_popPortlets = popPortlets;
    }

    public void setBaseStringSeed(String sSeed) {
        this.m_sBaseStringSeed = sSeed;
    }

    public String getBaseStringSeed() {
        return this.m_sBaseStringSeed;
    }

    public void populate(int iPortalSiteLevels, int iPortalSitesPerLevel, PortalSite rootPortal, UserCollection users) {
        int i;
        Session ses = SessionManager.getSession();
        TransactionContext txn = ses.getTransactionContext();
        String sBaseName = "Portal" + Utilities.getBaseString((String)this.m_sBaseStringSeed);
        ArrayList<PortalSite> portalSitesList = new ArrayList<PortalSite>(iPortalSiteLevels * iPortalSitesPerLevel);
        ArrayList<PortalSite> siblings = null;
        PortalSite parent = rootPortal;
        for (i = 0; i < iPortalSiteLevels; ++i) {
            txn.beginTxn();
            if (i > 0) {
                parent = (PortalSite)((Object)siblings.get(0));
            }
            siblings = new ArrayList<PortalSite>(iPortalSitesPerLevel);
            for (int j = 0; j < iPortalSitesPerLevel; ++j) {
                String sName = sBaseName + i + j;
                PortalSite portal = this.setupPortalSite(sName, parent, users);
                users.rewind();
                s_log.info((Object)("created PortalSite " + sName));
                if (s_log.isDebugEnabled()) {
                    String sURL = "";
                    PortalSite p = portal;
                    do {
                        sURL = p.getTitle() + "/" + sURL;
                    } while ((p = (PortalSite)p.getParentApplication()) != null);
                    s_log.debug((Object)("PortalSite " + sName + " has url " + sURL));
                }
                if (parent != null) {
                    s_log.info((Object)("PortalSite " + sName + " is a child of " + parent.getTitle()));
                }
                portalSitesList.add(portal);
                siblings.add(portal);
            }
            for (int y = 0; y < siblings.size(); ++y) {
                PortalSite bro = (PortalSite)((Object)siblings.get(y));
                for (int z = 0; z < siblings.size(); ++z) {
                    if (z == y) continue;
                    PortalSite sis = (PortalSite)((Object)siblings.get(z));
                    bro.addRelatedPortalSite(sis);
                    bro.save();
                    s_log.info((Object)("PortalSite " + bro.getTitle() + " is related to " + sis.getTitle()));
                }
            }
            txn.commitTxn();
        }
        s_log.info((Object)"Adding applications and AppPortlets to PortalSites");
        for (i = 0; i < portalSitesList.size(); ++i) {
            PopulateApps popApps = new PopulateApps(this.m_popAppPairs);
            popApps.setBaseStringSeed(Utilities.getBaseString((String)this.getBaseStringSeed()));
            PopulatePortlets popPortlets = new PopulatePortlets(this.m_popPortlets);
            PortalSite portal = (PortalSite)((Object)portalSitesList.get(i));
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("adding apps and portlets to PortalSite " + portal.getTitle()));
            }
            PortalTabCollection tabs = portal.getTabsForPortalSite();
            tabs.next();
            PortalTab tab = tabs.getPortalTab();
            tabs.close();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("add apps and ApplicationPortlets to tab " + tab.getTitle()));
            }
            popApps.populate(1, (Application)portal, (Portal)tab);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("add portlets to tab " + tab.getTitle()));
            }
            popPortlets.populate(1, (Portal)tab);
        }
    }

    private PortalSite setupPortalSite(String sName, PortalSite parent, UserCollection users) {
        PortalSite portal = PortalSite.createPortalSite(sName, sName, parent);
        int iTabs = 3;
        for (int i = 0; i < iTabs; ++i) {
            PortalTab tab = PortalTab.createTab("Tab" + i);
            tab.setLayout("W");
            portal.addPortalTab(tab);
        }
        while (users.next()) {
            User user = users.getUser();
            portal.addMember((Party)user);
            Iterator iter = user.getEmailAddresses();
            String sUser = iter.hasNext() ? ((EmailAddress)iter.next()).toString() : user.getDisplayName();
            s_log.info((Object)("added user " + sUser + " to portalsite " + sName));
        }
        portal.save();
        return portal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

