/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui.admin;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.DynamicListWizard;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PropertySheet;
import com.arsdigita.bebop.PropertySheetModel;
import com.arsdigita.bebop.PropertySheetModelBuilder;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.tree.TreeCellRenderer;
import com.arsdigita.bebop.tree.TreeModel;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.PortalSiteCollection;
import com.arsdigita.portalserver.ui.admin.ChildPortalCreateForm;
import com.arsdigita.portalserver.ui.admin.PortalTreeModelBuilder;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import com.arsdigita.xml.Element;
import org.apache.log4j.Logger;

public class RelatedPortalsPane {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$portalserver$ui$admin$RelatedPortalsPane == null ? (class$com$arsdigita$portalserver$ui$admin$RelatedPortalsPane = RelatedPortalsPane.class$("com.arsdigita.portalserver.ui.admin.RelatedPortalsPane")) : class$com$arsdigita$portalserver$ui$admin$RelatedPortalsPane));
    static /* synthetic */ Class class$com$arsdigita$portalserver$ui$admin$RelatedPortalsPane;

    private RelatedPortalsPane() {
    }

    public static Component create(final RequestLocal portalsiteRL) {
        final ACSObjectSelectionModel relatedSelection = new ACSObjectSelectionModel("relatedws");
        List rList = new List(new ListModelBuilder(){

            public void lock() {
            }

            public boolean isLocked() {
                return true;
            }

            public ListModel makeModel(List l, PageState ps) {
                return new RelatedPortalsModel((PortalSite)((Object)portalsiteRL.get(ps)));
            }
        });
        rList.setSelectionModel((SingleSelectionModel)relatedSelection);
        Label noRelated = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.no_linked_workspaces"));
        noRelated.setFontWeight("i");
        rList.setEmptyView((Component)noRelated);
        final DynamicListWizard related = new DynamicListWizard("Linked Portals", (Component)rList, (SingleSelectionModel)relatedSelection, "Link to a portal", (Component)new Label(""));
        related.setAddPane(RelatedPortalsPane.relatedAddPane(portalsiteRL, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                related.reset(ps);
            }
        }));
        related.setEditPane(RelatedPortalsPane.relatedEditPane(portalsiteRL, new RequestLocal(){

            protected Object initialValue(PageState ps) {
                return relatedSelection.getSelectedObject(ps);
            }
        }, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                related.reset(ps);
            }
        }));
        final ACSObjectSelectionModel childSelection = new ACSObjectSelectionModel("childws");
        List cList = new List(new ListModelBuilder(){

            public void lock() {
            }

            public boolean isLocked() {
                return true;
            }

            public ListModel makeModel(List l, PageState ps) {
                return new ChildPortalsModel((PortalSite)((Object)portalsiteRL.get(ps)));
            }
        });
        cList.setSelectionModel((SingleSelectionModel)childSelection);
        Label noChildren = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.no_child_workspaces"));
        noChildren.setFontWeight("i");
        cList.setEmptyView((Component)noChildren);
        DynamicListWizard child = new DynamicListWizard("Child Portals", (Component)cList, (SingleSelectionModel)childSelection, "Add a child portal", (Component)new Label(""));
        final RequestLocal newChildPortal = new RequestLocal();
        child.setAddPane(ChildPortalCreateForm.create(portalsiteRL, newChildPortal, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                childSelection.setSelectedKey(ps, (Object)((PortalSite)((Object)newChildPortal.get(ps))).getID().toString());
            }
        }));
        child.setEditPane(RelatedPortalsPane.childEditPane(portalsiteRL, new RequestLocal(){

            protected Object initialValue(PageState ps) {
                return childSelection.getSelectedObject(ps);
            }
        }));
        SimpleContainer retval = new SimpleContainer();
        retval.add((Component)related);
        retval.add((Component)child);
        return retval;
    }

    private static Component childEditPane(RequestLocal portalsiteRL, final RequestLocal childPortal) {
        BoxPanel retval = new BoxPanel(2);
        Label header = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.child_workspace_info"));
        header.setFontWeight("b");
        retval.add((Component)header);
        retval.add((Component)new PropertySheet(new PropertySheetModelBuilder(){

            public void lock() {
            }

            public boolean isLocked() {
                return true;
            }

            public PropertySheetModel makeModel(PropertySheet sheet, PageState ps) {
                return new PortalModel((PortalSite)((Object)childPortal.get(ps)));
            }
        }));
        BoxPanel bp = new BoxPanel(1);
        bp.add((Component)new Link((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.go_to_this_workspace")), new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState ps = e.getPageState();
                Link target = (Link)e.getTarget();
                PortalSite cp = (PortalSite)((Object)childPortal.get(ps));
                target.setTarget(cp.getPrimaryURL());
            }
        }));
        bp.add((Component)new Link((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.administer_this_workspace")), new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState ps = e.getPageState();
                Link target = (Link)e.getTarget();
                PortalSite cp = (PortalSite)((Object)childPortal.get(ps));
                target.setTarget(cp.getPrimaryURL() + "admin");
            }
        }));
        retval.add((Component)bp);
        return retval;
    }

    private static Component relatedAddPane(final RequestLocal portalsiteRL, ActionListener onAdd) {
        final Form confirmation = new Form("confirm", (Container)new SimpleContainer());
        confirmation.setMethod("post");
        BoxPanel retval = new BoxPanel(2){

            public void register(Page p) {
                p.setVisibleDefault((Component)confirmation, false);
            }
        };
        Tree psTree = new Tree(new PortalTreeModelBuilder()){

            public void generateXML(PageState ps, Element parent) {
                TreeModel tm = this.getTreeModel(ps);
                String key = (String)tm.getRoot(ps).getKey();
                this.expand((String)tm.getRoot(ps).getKey(), ps);
                super.generateXML(ps, parent);
            }
        };
        psTree.setCellRenderer((TreeCellRenderer)new PortalTreeModelBuilder.DefaultRenderer());
        final ACSObjectSelectionModel treeSelection = new ACSObjectSelectionModel("wstreeselect");
        psTree.setSelectionModel((SingleSelectionModel)treeSelection);
        retval.add((Component)psTree);
        treeSelection.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PageState ps = e.getPageState();
                confirmation.setVisible(ps, true);
            }
        });
        confirmation.add((Component)new Submit("Link selected portal"));
        confirmation.addProcessListener(new FormProcessListener((Container)retval, onAdd){
            private final /* synthetic */ Container val$retval;
            private final /* synthetic */ ActionListener val$onAdd;
            {
                this.val$retval = val$retval;
                this.val$onAdd = val$onAdd;
            }

            public void process(FormSectionEvent e) {
                PageState ps = e.getPageState();
                PortalSite related = (PortalSite)treeSelection.getSelectedObject(ps);
                PortalSite psite = (PortalSite)((Object)portalsiteRL.get(ps));
                PortalSiteCollection current = psite.getRelatedPortalSites();
                current.filterToPortalSite(related.getID());
                if (current.size() == 0L) {
                    psite.addRelatedPortalSite(related);
                    psite.save();
                }
                ps.reset((Component)this.val$retval);
                this.val$onAdd.actionPerformed(new ActionEvent((Component)this.val$retval, ps));
            }
        });
        retval.add((Component)confirmation);
        return retval;
    }

    private static Component relatedEditPane(final RequestLocal portalsiteRL, final RequestLocal relatedPortal, final ActionListener onRemove) {
        BoxPanel retval = new BoxPanel(2);
        Label header = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.linked_workspace_info"));
        header.setFontWeight("b");
        retval.add((Component)header);
        retval.add((Component)new PropertySheet(new PropertySheetModelBuilder(){

            public void lock() {
            }

            public boolean isLocked() {
                return true;
            }

            public PropertySheetModel makeModel(PropertySheet sheet, PageState ps) {
                return new PortalModel((PortalSite)((Object)relatedPortal.get(ps)));
            }
        }));
        ActionLink unLinkPortalPrompt = new ActionLink("Remove link to portal?");
        unLinkPortalPrompt.setConfirmation("Really remove link to portal?");
        unLinkPortalPrompt.addActionListener(new ActionListener((Container)retval){
            private final /* synthetic */ Container val$retval;
            {
                this.val$retval = val$retval;
            }

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                PortalSite psite = (PortalSite)((Object)portalsiteRL.get(ps));
                psite.removeRelatedPortalSite((PortalSite)((Object)relatedPortal.get(ps)));
                psite.save();
                onRemove.actionPerformed(new ActionEvent((Component)this.val$retval, ps));
            }
        });
        retval.add((Component)unLinkPortalPrompt);
        return retval;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class RelatedPortalsModel
    implements ListModel {
        private PortalSiteCollection m_psc;

        public RelatedPortalsModel(PortalSite p) {
            this.m_psc = p.getRelatedPortalSites();
        }

        public boolean next() {
            return this.m_psc.next();
        }

        public String getKey() {
            return this.m_psc.getID().toString();
        }

        public Object getElement() {
            return this.m_psc.getDisplayName();
        }
    }

    private static class ChildPortalsModel
    implements ListModel {
        private PortalSiteCollection m_psc;

        public ChildPortalsModel(PortalSite p) {
            this.m_psc = p.getChildPortalSites();
        }

        public boolean next() {
            return this.m_psc.next();
        }

        public String getKey() {
            return this.m_psc.getID().toString();
        }

        public Object getElement() {
            return this.m_psc.getDisplayName();
        }
    }

    static class PortalModel
    implements PropertySheetModel {
        private PortalSite m_p;
        private int m_counter = -1;

        PortalModel(PortalSite p) {
            this.m_p = p;
        }

        public boolean nextRow() {
            if (this.m_counter == 1) {
                return false;
            }
            ++this.m_counter;
            return true;
        }

        public String getLabel() {
            return this.getGlobalizedLabel().getKey();
        }

        public GlobalizedMessage getGlobalizedLabel() {
            if (this.m_counter == 0) {
                return GlobalizationUtil.globalize("cw.workspace.ui.admin.title");
            }
            if (this.m_counter == 1) {
                return GlobalizationUtil.globalize("cw.workspace.ui.admin.mission");
            }
            throw new IllegalStateException("invalid counter");
        }

        public String getValue() {
            if (this.m_counter == 0) {
                return this.m_p.getTitle();
            }
            if (this.m_counter == 1) {
                return this.m_p.getMission();
            }
            if (this.m_counter == 2) {
                PortalSite parent = PortalSite.getPortalSiteForApplication(this.m_p);
                if (parent == null) {
                    return "None";
                }
                return parent.getTitle();
            }
            throw new IllegalStateException("invalid counter");
        }
    }
}

