/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui.admin;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.kernel.BaseInitializer;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.portalserver.ui.admin.PortalCreator;
import com.arsdigita.portalserver.ui.admin.PortalSiteMap;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationSetup;
import com.arsdigita.web.ApplicationType;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public class Initializer
extends BaseInitializer {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/ui/admin/Initializer.java#8 $ by $Author: jparsons $, $DateTime: 2003/10/20 02:14:33 $";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$portalserver$ui$admin$Initializer == null ? (class$com$arsdigita$portalserver$ui$admin$Initializer = Initializer.class$("com.arsdigita.portalserver.ui.admin.Initializer")) : class$com$arsdigita$portalserver$ui$admin$Initializer));
    private Configuration m_conf = new Configuration();
    static /* synthetic */ Class class$com$arsdigita$portalserver$ui$admin$Initializer;

    public Configuration getConfiguration() {
        return this.m_conf;
    }

    public final void doStartup() {
        TransactionContext txn = SessionManager.getSession().getTransactionContext();
        txn.beginTxn();
        ApplicationType type = this.setupPortalCreator();
        this.setupPortalCreate(type);
        ApplicationType atype = this.setupPortalSitemapper();
        this.setupPortalSitemap(atype);
        txn.commitTxn();
    }

    private ApplicationType setupPortalCreator() {
        ApplicationSetup setup = new ApplicationSetup((Category)s_log);
        setup.setApplicationObjectType("com.arsdigita.workspace.ui.WorkspaceCreator");
        setup.setTitle("Portal Creator");
        setup.setDescription("Creates portals.");
        setup.setWorkspaceApplication(false);
        setup.setKey("portal-create");
        setup.setStylesheet("/packages/portalserver/xsl/portalserver.xsl");
        setup.setDispatcherClass("com.arsdigita.portalserver.ui.admin.PortalCreateDispatcher");
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            protected DomainObject doNewInstance(DataObject dataObject) {
                return new PortalCreator(dataObject);
            }
        });
        return setup.run();
    }

    private void setupPortalCreate(ApplicationType type) {
        if (!Application.isInstalled((String)"com.arsdigita.workspace.ui.WorkspaceCreator", (String)"/portal-admin/portal-create/")) {
            Application admin = Application.retrieveApplicationForPath((String)"/portal-admin/");
            if (admin == null) {
                s_log.warn((Object)"There is no application at /portal-admin/ so I can't install the portal create application.");
                return;
            }
            s_log.info((Object)"There is no Portal Creator application instance on /user-profile/.  Installing now.");
            Application app = Application.createApplication((ApplicationType)type, (String)"portal-create", (String)"Create Top-Level Portals", (Application)admin);
            app.setDescription("Create top-level portals.");
            app.save();
            s_log.info((Object)"Done installing Portal Creator on /portal-admin/portal-create/.");
        }
    }

    private ApplicationType setupPortalSitemapper() {
        ApplicationSetup setup = new ApplicationSetup((Category)s_log);
        setup.setApplicationObjectType("com.arsdigita.workspace.ui.PortalSiteMap");
        setup.setTitle("Portal Site Map");
        setup.setDescription("Displays and manages Portals");
        setup.setWorkspaceApplication(false);
        setup.setKey("portal-sitemap");
        setup.setStylesheet("/packages/portalserver/xsl/portal-sitemap.xsl");
        setup.setDispatcherClass("com.arsdigita.portalserver.ui.admin.PortalSiteMapDispatcher");
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            protected DomainObject doNewInstance(DataObject dataObject) {
                return new PortalSiteMap(dataObject);
            }
        });
        return setup.run();
    }

    private void setupPortalSitemap(ApplicationType type) {
        if (!Application.isInstalled((String)"com.arsdigita.workspace.ui.PortalSiteMap", (String)"/portal-admin/portal-sitemap/")) {
            Application admin = Application.retrieveApplicationForPath((String)"/portal-admin/");
            if (admin == null) {
                s_log.warn((Object)"There is no application at /portal-admin/ so I can't install the portal sitemap application.");
                return;
            }
            s_log.warn((Object)"There is no Portal Site Map application instance on /portal-admin/.  Installing now.");
            Application app = Application.createApplication((ApplicationType)type, (String)"portal-sitemap", (String)"Portal Site Map", (Application)admin);
            app.setDescription("Portal Site Map");
            app.save();
            s_log.warn((Object)"Done installing Portal Site Map on /portal-admin/portal-sitemap/.");
        }
    }

    public final void doShutdown() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

