/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui.admin;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.DynamicListWizard;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Image;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.kernel.Resource;
import com.arsdigita.portal.Portlet;
import com.arsdigita.portal.PortletType;
import com.arsdigita.portal.PortletTypeCollection;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.PortalTab;
import com.arsdigita.portalserver.PortalTabCollection;
import com.arsdigita.portalserver.ui.admin.ApplicationModifyComponent;
import com.arsdigita.portalserver.ui.admin.LockableLinks;
import com.arsdigita.portalserver.ui.admin.PortletAddForm;
import com.arsdigita.portalserver.ui.admin.PortletLayoutComponent;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import com.arsdigita.web.ApplicationType;
import java.math.BigDecimal;
import java.util.ListIterator;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public class DisplayPane
extends DynamicListWizard {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/ui/admin/DisplayPane.java#8 $ by $Author: jparsons $, $DateTime: 2003/11/13 12:59:02 $";
    private static final Logger s_cat = Logger.getLogger((String)(class$com$arsdigita$portalserver$ui$admin$ApplicationsPane == null ? (class$com$arsdigita$portalserver$ui$admin$ApplicationsPane = DisplayPane.class$("com.arsdigita.portalserver.ui.admin.ApplicationsPane")) : class$com$arsdigita$portalserver$ui$admin$ApplicationsPane).getName());
    final ModalContainer m_editContainer = new ModalContainer();
    SimpleContainer m_mainDisplay;
    ApplicationModifyComponent m_portletModify;
    PortletAddForm m_portletAddForm;
    RenameTabForm m_renameTabForm;
    DeleteTabForm m_deleteTabForm;
    List m_layouts;
    RequestLocal selectedTabIDRL;
    static final String[] m_layoutNames = new String[]{"W", "NW", "WN", "NWN", "NNN"};
    BigDecimalParameter m_selectedPortletParam;
    static final String FOUR_SPACE_INDENT_STRING = "&nbsp;&nbsp;&nbsp;&nbsp;";
    static /* synthetic */ Class class$com$arsdigita$portalserver$ui$admin$ApplicationsPane;

    public DisplayPane(final RequestLocal portalsiteRL) {
        super("Current Tabs. Use the arrows to shift tab position.", new ListModelBuilder(){

            public ListModel makeModel(List l, PageState ps) {
                PortalSite psite = (PortalSite)((Object)portalsiteRL.get(ps));
                return new TabListModel(psite);
            }

            public void lock() {
            }

            public boolean isLocked() {
                return true;
            }
        }, "Add a tab", (Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.there_currently_is_no_tab_selected_please_select_a_tab")));
        final DisplayPane dlw = this;
        Form addForm = new Form("addTab");
        addForm.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.new_tab_name")));
        final TextField newTabName = new TextField("name");
        newTabName.getParameterModel().addParameterListener((ParameterListener)new NotEmptyValidationListener());
        newTabName.setSize(40);
        addForm.add((Component)newTabName);
        addForm.add((Component)new Label());
        addForm.add((Component)new Submit("Add tab"));
        addForm.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                PortalSite psite = (PortalSite)((Object)portalsiteRL.get(ps));
                PortalTab newTab = PortalTab.createTab((String)newTabName.getValue(ps), (Resource)psite);
                psite.addPortalTab(newTab);
                newTab.save();
                psite.save();
                List list = (List)dlw.getListingComponent();
                list.getSelectionModel().setSelectedKey(ps, (Object)newTab.getID().toString());
            }
        });
        this.setAddPane((Component)addForm);
        this.selectedTabIDRL = new RequestLocal(){

            protected Object initialValue(PageState ps) {
                String tabIDstr = (String)dlw.getSelectionModel().getSelectedKey(ps);
                return new BigDecimal(tabIDstr);
            }
        };
        this.m_selectedPortletParam = new BigDecimalParameter("selectedPortlet");
        this.m_mainDisplay = new BoxPanel(2);
        PortletLayoutComponent plc = new PortletLayoutComponent(portalsiteRL, this.selectedTabIDRL){

            protected void handleConfigure(PageState ps, BigDecimal id) {
                ps.setValue((ParameterModel)DisplayPane.this.m_selectedPortletParam, (Object)id);
                DisplayPane.this.m_editContainer.setVisibleComponent(ps, (Component)DisplayPane.this.m_portletModify);
            }
        };
        LockableLinks locklinks = new LockableLinks(portalsiteRL, this.selectedTabIDRL);
        this.m_mainDisplay.add((Component)locklinks);
        this.m_mainDisplay.add((Component)plc);
        BoxPanel links = new BoxPanel(1, true);
        ActionLink renameLink = new ActionLink((String)GlobalizationUtil.globalize("cw.workspace.ui.admin.rename_tab").localize());
        renameLink.setClassAttr("actionLink");
        renameLink.addActionListener((ActionListener)new RenameLinkListener());
        links.add((Component)renameLink);
        ActionLink deleteLink = new ActionLink((String)GlobalizationUtil.globalize("cw.workspace.ui.admin.delete_tab").localize()){

            public boolean isVisible(PageState ps) {
                PortalSite psite = (PortalSite)((Object)portalsiteRL.get(ps));
                PortalTabCollection pstc = psite.getTabsForPortalSite();
                return pstc.size() > 1L;
            }
        };
        deleteLink.setClassAttr("actionLink");
        deleteLink.addActionListener((ActionListener)new DeleteLinkListener());
        links.add((Component)deleteLink);
        this.m_mainDisplay.add((Component)links);
        final BigDecimalParameter portletTypeParam = new BigDecimalParameter("typeID");
        Form addPortlet = new Form("ap1", (Container)new GridPanel(1)){

            public void register(Page p) {
                super.register(p);
                p.addComponentStateParam((Component)this, (ParameterModel)portletTypeParam);
            }
        };
        Image image = new Image("/assets/cw/general/add.gif");
        image.setBorder("0");
        SimpleContainer imageLabelSC = new SimpleContainer();
        imageLabelSC.add((Component)image);
        imageLabelSC.add((Component)new Label("To add a portlet to this page, first choose a type: "));
        addPortlet.add((Component)imageLabelSC);
        final SingleSelect portletTypeSelect = new SingleSelect("ptype");
        portletTypeSelect.addValidationListener((ParameterListener)new NotNullValidationListener());
        PortletTypeCollection ptc = PortletType.retrieveAllPortletTypes();
        ptc.addOrder("title");
        while (ptc.next()) {
            ApplicationType providerAppType = ptc.getPortletType().getProviderApplicationType();
            if (providerAppType != null) {
                portletTypeSelect.addOption(new Option(ptc.getID().toString(), ptc.getTitle() + " (" + providerAppType.getTitle() + ") "));
                continue;
            }
            portletTypeSelect.addOption(new Option(ptc.getID().toString(), ptc.getTitle()));
        }
        SimpleContainer selectorSC = new SimpleContainer();
        selectorSC.add((Component)portletTypeSelect);
        selectorSC.add((Component)new Submit("Go"));
        addPortlet.add((Component)selectorSC);
        addPortlet.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                DisplayPane.this.m_editContainer.setVisibleComponent(ps, (Component)DisplayPane.this.m_portletAddForm);
                ps.setValue((ParameterModel)portletTypeParam, (Object)new BigDecimal((String)portletTypeSelect.getValue(ps)));
                DisplayPane.this.m_portletAddForm.activate(ps);
            }
        });
        this.m_mainDisplay.add((Component)addPortlet);
        BoxPanel tabLayouts = new BoxPanel(1, true);
        ListModelBuilder lmb = new ListModelBuilder(){
            boolean m_isLocked;

            public ListModel makeModel(List l, PageState pageState) {
                return new LayoutListModel(pageState);
            }

            public void lock() {
                this.m_isLocked = true;
            }

            public boolean isLocked() {
                return this.m_isLocked;
            }
        };
        this.m_layouts = new List(lmb);
        this.m_layouts.setClassAttr("tabLayouts");
        this.m_layouts.setCellRenderer((ListCellRenderer)new LayoutListCellRenderer());
        this.m_layouts.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PageState ps = e.getPageState();
                String key = (String)((List)dlw.getListingComponent()).getSelectedKey(ps);
                BigDecimal bd = new BigDecimal(key);
                PortalTab ptab = PortalTab.retrieveTab(bd);
                String laykey = (String)DisplayPane.this.m_layouts.getSelectedKey(ps);
                Integer lk = new Integer(laykey);
                ptab.setLayout(m_layoutNames[lk]);
                ptab.save();
            }
        });
        tabLayouts.add((Component)this.m_layouts);
        this.m_mainDisplay.add((Component)tabLayouts);
        this.m_portletAddForm = new PortletAddForm(portalsiteRL, this.selectedTabIDRL, new RequestLocal(){

            protected Object initialValue(PageState ps) {
                BigDecimal id = (BigDecimal)ps.getValue((ParameterModel)portletTypeParam);
                if (id == null) {
                    return null;
                }
                return PortletType.retrievePortletType((BigDecimal)id);
            }
        });
        this.m_portletAddForm.addCompletionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PageState ps = ev.getPageState();
                ps.reset((Component)DisplayPane.this.m_editContainer);
            }
        });
        RequestLocal selectedPortletRL = new RequestLocal(){

            public Object initialValue(PageState ps) {
                BigDecimal portletID = (BigDecimal)ps.getValue((ParameterModel)DisplayPane.this.m_selectedPortletParam);
                if (portletID == null) {
                    return null;
                }
                return Portlet.retrievePortlet((BigDecimal)portletID);
            }
        };
        ActionListener reset = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PageState ps = ev.getPageState();
                ps.reset((Component)DisplayPane.this.m_editContainer);
                ps.setValue((ParameterModel)DisplayPane.this.m_selectedPortletParam, null);
            }
        };
        this.m_portletModify = new ApplicationModifyComponent(selectedPortletRL, true, reset, reset);
        this.m_renameTabForm = new RenameTabForm(this.selectedTabIDRL);
        this.m_deleteTabForm = new DeleteTabForm(this.selectedTabIDRL);
        this.m_editContainer.add((Component)this.m_mainDisplay);
        this.m_editContainer.add((Component)this.m_portletModify);
        this.m_editContainer.add((Component)this.m_portletAddForm);
        this.m_editContainer.add((Component)this.m_renameTabForm);
        this.m_editContainer.add((Component)this.m_deleteTabForm);
        this.setEditPane((Component)this.m_editContainer);
        ((List)this.getListingComponent()).addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                ev.getPageState().reset((Component)DisplayPane.this.m_editContainer);
            }
        });
        ((List)this.getListingComponent()).setCellRenderer(new ListCellRenderer(){

            public Component getComponent(List list, PageState state, Object value, String key, int index, boolean isSelected) {
                int indent_ctr = 0;
                boolean isFirst = false;
                boolean isLast = false;
                SimpleContainer container = new SimpleContainer();
                BigDecimal bd = new BigDecimal(key);
                PortalTab ptab = PortalTab.retrieveTab(bd);
                PortalSite psite = ptab.getPortalSite();
                PortalTabCollection ptcoll = psite.getTabsForPortalSite();
                long size = ptcoll.size();
                if (size == 1L) {
                    if (!dlw.getAddLink().isSelected(state)) {
                        list.setSelectedKey(state, key);
                        Label tabName = new Label(value.toString());
                        container.add((Component)tabName);
                        DisplayPane.this.selectedTabIDRL.set(state, (Object)bd);
                        return container;
                    }
                } else {
                    indent_ctr = 0;
                    while (ptcoll.next()) {
                        ++indent_ctr;
                        if (bd.compareTo(ptcoll.getID()) != 0) continue;
                        if (indent_ctr == 1) {
                            isFirst = true;
                        }
                        if ((long)indent_ctr != size) break;
                        isLast = true;
                        break;
                    }
                }
                ptcoll.close();
                StringBuffer buf = new StringBuffer(200);
                for (int i = 0; i < indent_ctr - 1; ++i) {
                    buf.append(DisplayPane.FOUR_SPACE_INDENT_STRING);
                }
                if (isSelected) {
                    Label tabName = new Label(value.toString());
                    tabName.setFontWeight("b");
                    Label labelLeft = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.shift_left"));
                    Label labelRight = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.shift_right"));
                    ControlLink linkLeft = new ControlLink(this, (Component)labelLeft){
                        private final /* synthetic */ 15 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void setControlEvent(PageState s) {
                            s.setControlEvent((Component)15.access$200(this.this$1), "left", "1");
                        }
                    };
                    ControlLink linkRight = new ControlLink(this, (Component)labelRight){
                        private final /* synthetic */ 15 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void setControlEvent(PageState s) {
                            s.setControlEvent((Component)15.access$200(this.this$1), "right", "1");
                        }
                    };
                    linkLeft.setClassAttr("shiftleft");
                    linkRight.setClassAttr("shiftright");
                    if (isFirst) {
                        container.add((Component)tabName);
                        container.add((Component)linkRight);
                    } else if (isLast) {
                        container.add((Component)linkLeft);
                        container.add((Component)tabName);
                    } else {
                        container.add((Component)linkLeft);
                        container.add((Component)tabName);
                        container.add((Component)linkRight);
                    }
                } else {
                    String ttab = buf.toString() + value.toString();
                    Label tabName = new Label(ttab, false);
                    ControlLink l = new ControlLink((Component)tabName);
                    container.add((Component)l);
                }
                return container;
            }

            static /* synthetic */ DynamicListWizard access$200(15 x0) {
                return x0.dlw;
            }
        });
    }

    public void register(Page p) {
        super.register(p);
        p.addComponentStateParam((Component)this, (ParameterModel)this.m_selectedPortletParam);
    }

    public void respond(PageState state) throws ServletException {
        String tabIDstr = (String)this.getSelectionModel().getSelectedKey(state);
        BigDecimal tabID = new BigDecimal(tabIDstr);
        String name = state.getControlEventName();
        if (name.compareTo("left") == 0) {
            PortalTab ptab = PortalTab.retrieveTab(tabID);
            PortalSite psite = ptab.getPortalSite();
            psite.swapTabWithPrevious(ptab);
        } else if (name.compareTo("right") == 0) {
            PortalTab ptab = PortalTab.retrieveTab(tabID);
            PortalSite psite = ptab.getPortalSite();
            psite.swapTabWithNext(ptab);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class LayoutListCellRenderer
    implements ListCellRenderer {
        LayoutListCellRenderer() {
        }

        public Component getComponent(List list, PageState pageState, Object value, String key, int index, boolean isSelected) {
            String val = (String)value;
            if (isSelected) {
                Label label = new Label(val);
                label.setClassAttr(val);
                return label;
            }
            ControlLink link = new ControlLink(val);
            link.setClassAttr(val);
            link.setStyleAttr("HooHaH");
            return link;
        }
    }

    private class LayoutListModel
    implements ListModel {
        Vector vec = new Vector();
        ListIterator vl;

        LayoutListModel(PageState pageState) {
            this.vec.add("W");
            this.vec.add("NW");
            this.vec.add("WN");
            this.vec.add("NWN");
            this.vec.add("NNN");
            this.vl = this.vec.listIterator();
        }

        public boolean next() {
            return this.vl.hasNext();
        }

        public Object getElement() {
            return this.vl.next();
        }

        public String getKey() {
            int dex = this.vl.previousIndex();
            Integer it = new Integer(++dex);
            return it.toString();
        }
    }

    private class DeleteLinkListener
    implements ActionListener {
        private DeleteLinkListener() {
        }

        public void actionPerformed(ActionEvent event) {
            PageState ps = event.getPageState();
            DisplayPane.this.m_editContainer.setVisibleComponent(ps, (Component)DisplayPane.this.m_deleteTabForm);
        }
    }

    private class RenameLinkListener
    implements ActionListener {
        private RenameLinkListener() {
        }

        public void actionPerformed(ActionEvent event) {
            PageState ps = event.getPageState();
            DisplayPane.this.m_editContainer.setVisibleComponent(ps, (Component)DisplayPane.this.m_renameTabForm);
        }
    }

    public class DeleteTabForm
    extends Form
    implements FormProcessListener {
        private TextField currenttabName;
        private Label instruction;
        private Submit button;
        private Submit cancelbutton;
        private RequestLocal m_tabIDRL;

        public DeleteTabForm(RequestLocal SelectedTabIDRL) {
            super("deletetabform");
            this.m_tabIDRL = SelectedTabIDRL;
            this.instruction = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.are_you_sure_you_want_to_delete_this_tab"));
            this.instruction.addPrintListener(new PrintListener(this){
                private final /* synthetic */ DeleteTabForm this$1;
                {
                    this.this$1 = this$1;
                }

                public void prepare(PrintEvent e) {
                    PageState s = e.getPageState();
                    String prefixstr = "Are you sure you want to delete the ";
                    BigDecimal tabID = (BigDecimal)DeleteTabForm.access$400(this.this$1).get(s);
                    PortalTab ptab = PortalTab.retrieveTab(tabID);
                    Label t = (Label)e.getTarget();
                    t.setLabel(prefixstr + ptab.getTitle() + " tab?");
                }
            });
            this.button = new Submit("Delete this tab");
            this.button.setButtonLabel("Delete this tab");
            this.cancelbutton = new Submit("Cancel");
            this.cancelbutton.setButtonLabel("Cancel");
            this.add((Component)this.instruction);
            this.add((Component)this.button);
            this.add((Component)this.cancelbutton);
            this.addProcessListener(this);
        }

        public void process(FormSectionEvent e) {
            PageState s = e.getPageState();
            if (this.button.isSelected(s)) {
                BigDecimal tabID = (BigDecimal)this.m_tabIDRL.get(s);
                PortalTab ptab = PortalTab.retrieveTab(tabID);
                ptab.delete();
                DisplayPane.this.getSelectionModel().clearSelection(s);
                DisplayPane.this.reset(s);
            }
            s.reset((Component)DisplayPane.this.m_editContainer);
        }

        static /* synthetic */ RequestLocal access$400(DeleteTabForm x0) {
            return x0.m_tabIDRL;
        }
    }

    public class RenameTabForm
    extends Form
    implements FormProcessListener {
        private TextField currenttabName;
        private Label instruction;
        private Submit button;
        private Submit cancelbutton;
        private RequestLocal m_tabIDRL;

        public RenameTabForm(RequestLocal SelectedTabIDRL) {
            super("renametabform");
            this.m_tabIDRL = SelectedTabIDRL;
            this.instruction = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.enter_new_name_for_this_tab_in_text_field"));
            this.currenttabName = new TextField("CurrentTabName");
            this.currenttabName.setDefaultValue((Object)"");
            this.currenttabName.setSize(40);
            this.currenttabName.addValidationListener((ParameterListener)new NotNullValidationListener("Every Tab must have a name!"));
            try {
                this.currenttabName.addPrintListener(new PrintListener(this){
                    private final /* synthetic */ RenameTabForm this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void prepare(PrintEvent e) {
                        PageState s = e.getPageState();
                        BigDecimal tabID = (BigDecimal)RenameTabForm.access$300(this.this$1).get(s);
                        PortalTab ptab = PortalTab.retrieveTab(tabID);
                        TextField tf = (TextField)e.getTarget();
                        tf.setValue(s, (Object)ptab.getTitle());
                    }
                });
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
            this.button = new Submit("Rename tab");
            this.button.setButtonLabel("Rename tab");
            this.cancelbutton = new Submit("Cancel");
            this.cancelbutton.setButtonLabel("Cancel");
            this.add((Component)this.instruction);
            this.add((Component)this.currenttabName);
            this.add((Component)this.button);
            this.add((Component)this.cancelbutton);
            this.addProcessListener(this);
        }

        public void process(FormSectionEvent e) {
            PageState s = e.getPageState();
            if (this.button.isSelected(s)) {
                BigDecimal tabID = (BigDecimal)this.m_tabIDRL.get(s);
                PortalTab ptab = PortalTab.retrieveTab(tabID);
                ptab.setTitle(this.currenttabName.getValue(s).toString());
                ptab.save();
            }
            s.reset((Component)DisplayPane.this.m_editContainer);
        }

        static /* synthetic */ RequestLocal access$300(RenameTabForm x0) {
            return x0.m_tabIDRL;
        }
    }

    static class TabListModel
    implements ListModel {
        PortalTabCollection m_tabs;
        PortalTab m_currTab;

        public TabListModel(PortalSite psite) {
            this.m_tabs = psite.getTabsForPortalSite();
        }

        public boolean next() {
            if (!this.m_tabs.next()) {
                return false;
            }
            this.m_currTab = this.m_tabs.getPortalTab();
            return true;
        }

        public Object getElement() {
            return this.m_currTab.getTitle();
        }

        public String getKey() {
            return this.m_currTab.getID().toString();
        }
    }
}

