/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui.admin;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.CompoundComponent;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.kernel.Resource;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.ui.ResourceConfigFormSection;
import com.arsdigita.portal.PortletType;
import com.arsdigita.web.ApplicationType;
import com.arsdigita.web.ApplicationTypeCollection;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.HashMap;

public class ApplicationModifyComponent
extends CompoundComponent {
    private RequestLocal m_appRL;
    private HashMap m_configureComponents;

    public ApplicationModifyComponent(RequestLocal appRL, boolean forPortlets, ActionListener onSuccess, ActionListener onCancel) {
        this(appRL, forPortlets, new DefaultBuilder(appRL, onSuccess, onCancel));
    }

    public ApplicationModifyComponent(RequestLocal appRL, boolean forPortlets, Builder builder) {
        this.m_appRL = appRL;
        this.m_configureComponents = new HashMap();
        Object atc = forPortlets ? PortletType.retrieveAllPortletTypes() : ApplicationType.retrieveAllApplicationTypes();
        while (atc.next()) {
            Object at = forPortlets ? atc.getPortletType() : ((ApplicationTypeCollection)atc).getApplicationType();
            ResourceConfigFormSection fs = at.getModifyFormSection(this.m_appRL);
            if (fs == null) continue;
            Component c = builder.build(fs);
            this.m_configureComponents.put(at.getID(), c);
            this.add(c);
        }
    }

    public Component get(PageState ps) {
        ResourceType type = ((Resource)this.m_appRL.get(ps)).getResourceType();
        if (!this.canModify(type.getID())) {
            throw new IllegalStateException("Cannot display form for a " + type.getTitle());
        }
        return (Component)this.m_configureComponents.get(type.getID());
    }

    public void generateXML(PageState ps, Element parentElt) {
        this.get(ps).generateXML(ps, parentElt);
    }

    boolean canModify(BigDecimal resTypeID) {
        return this.m_configureComponents.containsKey(resTypeID);
    }

    boolean canModify(ResourceType rt) {
        return this.m_configureComponents.containsKey(rt.getID());
    }

    public static class DefaultBuilder
    implements Builder {
        private final RequestLocal m_appRL;
        private final ActionListener m_onSuccess;
        private final ActionListener m_onCancel;

        public DefaultBuilder(RequestLocal appRL, ActionListener onSuccess, ActionListener onCancel) {
            this.m_appRL = appRL;
            this.m_onSuccess = onSuccess;
            this.m_onCancel = onCancel;
        }

        public Component build(ResourceConfigFormSection acfs) {
            Form f = new Form("ac", (Container)new GridPanel(1));
            f.add((Component)acfs);
            BoxPanel buttons = new BoxPanel(1);
            Submit update = new Submit("Update");
            Submit cancel = new Submit("Cancel");
            buttons.add((Component)update);
            buttons.add((Component)cancel);
            f.add((Component)buttons);
            f.addProcessListener(new FormProcessListener(this, update, acfs, f, cancel){
                private final /* synthetic */ Submit val$update;
                private final /* synthetic */ ResourceConfigFormSection val$acfs;
                private final /* synthetic */ Form val$f;
                private final /* synthetic */ Submit val$cancel;
                private final /* synthetic */ DefaultBuilder this$0;
                {
                    this.this$0 = this$0;
                    this.val$update = val$update;
                    this.val$acfs = val$acfs;
                    this.val$f = val$f;
                    this.val$cancel = val$cancel;
                }

                public void process(FormSectionEvent ev) {
                    PageState ps = ev.getPageState();
                    if (this.val$update.isSelected(ps)) {
                        this.val$acfs.modifyResource(ps);
                        ((Resource)DefaultBuilder.access$000(this.this$0).get(ps)).save();
                        DefaultBuilder.access$100(this.this$0).actionPerformed(new ActionEvent((Component)this.val$f, ps));
                    } else if (this.val$cancel.isSelected(ps)) {
                        DefaultBuilder.access$200(this.this$0).actionPerformed(new ActionEvent((Component)this.val$f, ps));
                    }
                }
            });
            return f;
        }

        static /* synthetic */ RequestLocal access$000(DefaultBuilder x0) {
            return x0.m_appRL;
        }

        static /* synthetic */ ActionListener access$100(DefaultBuilder x0) {
            return x0.m_onSuccess;
        }

        static /* synthetic */ ActionListener access$200(DefaultBuilder x0) {
            return x0.m_onCancel;
        }
    }

    public static interface Builder {
        public Component build(ResourceConfigFormSection var1);
    }
}

