/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.CompoundComponent;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.GridTableModel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PropertySheet;
import com.arsdigita.bebop.PropertySheetModel;
import com.arsdigita.bebop.PropertySheetModelBuilder;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.table.AbstractTableModelBuilder;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainCollectionIterator;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.portalserver.Icons;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.Role;
import com.arsdigita.portalserver.RoleCollection;
import com.arsdigita.portalserver.permissions.PartyPermissionEdit;
import com.arsdigita.portalserver.ui.ParticipantModel;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import com.arsdigita.toolbox.ui.IteratorListModel;
import java.math.BigDecimal;
import java.util.Iterator;
import org.apache.log4j.Category;

public class ParticipantEdit
extends CompoundComponent {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/ui/ParticipantEdit.java#5 $$Author: ashah $$DateTime: 2003/08/15 15:50:10 $";
    private static Category s_log = Category.getInstance((String)(class$com$arsdigita$portalserver$ui$ParticipantEdit == null ? (class$com$arsdigita$portalserver$ui$ParticipantEdit = ParticipantEdit.class$("com.arsdigita.portalserver.ui.ParticipantEdit")) : class$com$arsdigita$portalserver$ui$ParticipantEdit).getName());
    private static final IteratorListModel.KeyFunction s_keyFunc = new IteratorListModel.KeyFunction(){

        public String getKey(Object obj) {
            return ((Role)((Object)obj)).getID().toString();
        }
    };
    static /* synthetic */ Class class$com$arsdigita$portalserver$ui$ParticipantEdit;

    public ParticipantEdit(final Container container, final RequestLocal portalsiteRL, final RequestLocal participantRL, final ActionListener onDelete) {
        super(container);
        ((BoxPanel)container).setWidth("100%");
        Label header = new Label(GlobalizationUtil.globalize("cw.workspace.ui.participant_info"));
        header.setFontWeight("b");
        this.add((Component)header);
        this.add((Component)new PropertySheet(new PropertySheetModelBuilder(){

            public void lock() {
            }

            public boolean isLocked() {
                return container.isLocked();
            }

            public PropertySheetModel makeModel(PropertySheet sheet, PageState ps) {
                return new ParticipantModel((Party)participantRL.get(ps), (PortalSite)((Object)portalsiteRL.get(ps)), false);
            }
        }));
        this.add((Component)new Label(""));
        Label roleHeader = new Label(GlobalizationUtil.globalize("cw.workspace.ui.participant_roles"));
        roleHeader.setFontWeight("b");
        this.add((Component)roleHeader);
        String GRANT = "grant";
        String REVOKE = "revoke";
        final Table roleEdit = new Table(){

            public void respond(PageState ps) {
                Role role;
                String eventName = ps.getControlEventName();
                if (!"grant".equals(eventName) && !"revoke".equals(eventName)) {
                    throw new IllegalStateException("Unknown event name");
                }
                BigDecimal roleID = new BigDecimal(ps.getControlEventValue());
                Party participant = (Party)participantRL.get(ps);
                try {
                    role = new Role(roleID);
                }
                catch (DataObjectNotFoundException ex) {
                    throw new IllegalStateException("Unknown role ID");
                }
                if ("grant".equals(eventName)) {
                    if (!role.hasDirectMemberOrSubgroup(participant)) {
                        role.addMemberOrSubgroup(participant);
                        role.save();
                    }
                } else if (role.hasDirectMemberOrSubgroup(participant)) {
                    role.removeMemberOrSubgroup(participant);
                    role.save();
                }
            }
        };
        roleEdit.setHeader(null);
        roleEdit.getColumnModel().add(new TableColumn(0));
        roleEdit.getColumnModel().add(new TableColumn(1));
        roleEdit.getColumnModel().add(new TableColumn(2));
        roleEdit.setClassAttr("plain");
        roleEdit.setModelBuilder((TableModelBuilder)new AbstractTableModelBuilder(){

            public TableModel makeModel(Table t, PageState ps) {
                PortalSite psite = (PortalSite)((Object)portalsiteRL.get(ps));
                RoleCollection rc = psite.getRoles();
                DomainCollectionIterator roleIter = new DomainCollectionIterator((DomainCollection)rc);
                IteratorListModel roleLM = new IteratorListModel((Iterator)roleIter, s_keyFunc);
                return new GridTableModel((ListModel)roleLM, 3);
            }
        });
        final Label emptyLabel = new Label("");
        final RequestLocal dynamicLabel = new RequestLocal(){

            public Object initialValue(PageState ps) {
                return new Label();
            }
        };
        final RequestLocal eventValueRL = new RequestLocal();
        final RequestLocal grantDisplay = new RequestLocal(){

            public Object initialValue(PageState state) {
                SimpleContainer result = new SimpleContainer();
                result.add((Component)new ControlLink(this, (Component)Icons.CHECK_EMPTY_16){
                    private final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void setControlEvent(PageState ps) {
                        ps.setControlEvent((Component)6.access$100(this.this$1), "grant", (String)6.access$200(this.this$1).get(ps));
                    }
                });
                result.add((Component)dynamicLabel.get(state));
                return result;
            }

            static /* synthetic */ Table access$100(6 x0) {
                return x0.roleEdit;
            }

            static /* synthetic */ RequestLocal access$200(6 x0) {
                return x0.eventValueRL;
            }
        };
        final RequestLocal revokeDisplay = new RequestLocal(){

            public Object initialValue(PageState state) {
                SimpleContainer result = new SimpleContainer();
                result.add((Component)new ControlLink(this, (Component)Icons.CHECK_FULL_16){
                    private final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void setControlEvent(PageState ps) {
                        ps.setControlEvent((Component)8.access$300(this.this$1), "revoke", (String)8.access$400(this.this$1).get(ps));
                    }
                });
                result.add((Component)dynamicLabel.get(state));
                return result;
            }

            static /* synthetic */ Table access$300(8 x0) {
                return x0.roleEdit;
            }

            static /* synthetic */ RequestLocal access$400(8 x0) {
                return x0.eventValueRL;
            }
        };
        roleEdit.setDefaultCellRenderer((TableCellRenderer)new DefaultTableCellRenderer(){

            public Component getComponent(Table t, PageState ps, Object value, boolean isSelected, Object key, int row, int col) {
                if (value == null) {
                    return emptyLabel;
                }
                Party participant = (Party)participantRL.get(ps);
                Role role = (Role)((Object)value);
                if (value != null) {
                    eventValueRL.set(ps, (Object)role.getID().toString());
                    Label l = (Label)dynamicLabel.get(ps);
                    l.setLabel(role.getRoleName());
                    if (role.hasDirectMemberOrSubgroup(participant)) {
                        return (Component)revokeDisplay.get(ps);
                    }
                    return (Component)grantDisplay.get(ps);
                }
                return emptyLabel;
            }
        });
        this.add((Component)roleEdit);
        this.add((Component)new PartyPermissionEdit("Additional Privileges", portalsiteRL, participantRL));
        ActionLink removeParticipant = new ActionLink("Remove this participant from this portal");
        removeParticipant.setClassAttr("actionLink");
        removeParticipant.setConfirmation("Really remove participant from Portal?");
        removeParticipant.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                PortalSite psite = (PortalSite)((Object)portalsiteRL.get(ps));
                Party p = (Party)participantRL.get(ps);
                psite.assertPrivilege(PrivilegeDescriptor.ADMIN);
                KernelExcursion ex = new KernelExcursion(this, psite, p){
                    private final /* synthetic */ PortalSite val$psite;
                    private final /* synthetic */ Party val$p;
                    private final /* synthetic */ 11 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$psite = val$psite;
                        this.val$p = val$p;
                    }

                    protected void excurse() {
                        this.setEffectiveParty(Kernel.getSystemParty());
                        this.val$psite.removeParticipant(this.val$p);
                        this.val$psite.save();
                    }
                };
                ex.run();
                onDelete.actionPerformed(new ActionEvent((Component)ParticipantEdit.this, ps));
            }
        });
        this.add((Component)removeParticipant);
    }

    public ParticipantEdit(RequestLocal portalsiteRL, RequestLocal participantRL, ActionListener onDelete) {
        this((Container)new BoxPanel(2), portalsiteRL, participantRL, onDelete);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

