/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.DynamicListWizard;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.FormErrorDisplay;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.list.AbstractListModelBuilder;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.OID;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.Role;
import com.arsdigita.portalserver.RoleCollection;
import com.arsdigita.portalserver.ui.ParticipantDisplay;
import com.arsdigita.portalserver.ui.ParticipantEdit;
import com.arsdigita.portalserver.ui.ParticipantListModel;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import com.arsdigita.toolbox.ui.IteratorListModel;
import com.arsdigita.toolbox.ui.PrivilegedComponentSelector;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.RedirectSignal;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Category;

public class ParticipantBrowsePane {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/ui/ParticipantBrowsePane.java#7 $$Author: ashah $$DateTime: 2003/08/15 15:50:10 $";
    private static Category s_log = Category.getInstance((String)(class$com$arsdigita$portalserver$ui$ParticipantBrowsePane == null ? (class$com$arsdigita$portalserver$ui$ParticipantBrowsePane = ParticipantBrowsePane.class$("com.arsdigita.portalserver.ui.ParticipantBrowsePane")) : class$com$arsdigita$portalserver$ui$ParticipantBrowsePane).getName());
    static /* synthetic */ Class class$com$arsdigita$portalserver$ui$ParticipantBrowsePane;

    private ParticipantBrowsePane() {
    }

    public static Component createForUser(RequestLocal portalsite, StringParameter actionParam, ActionListener selectSearch) {
        return ParticipantBrowsePane.buildBrowsePane(portalsite, actionParam, selectSearch, false);
    }

    public static Component createForAdmin(RequestLocal portalsite, StringParameter actionParam, ActionListener selectSearch) {
        return ParticipantBrowsePane.buildBrowsePane(portalsite, actionParam, selectSearch, true);
    }

    private static Component buildBrowsePane(final RequestLocal portalsiteRL, final StringParameter actionParam, final ActionListener selectBrowse, final boolean isAdmin) {
        final ACSObjectSelectionModel selectionModel = new ACSObjectSelectionModel("selectedparticipant");
        final List participantList = new List();
        participantList.setSelectionModel((SingleSelectionModel)selectionModel);
        participantList.setEmptyView((Component)new Label(""));
        final List initialsList = new List(){

            public boolean isVisible(PageState ps) {
                PortalSite psite = (PortalSite)((Object)portalsiteRL.get(ps));
                return psite.getParticipantCount() > 20L && super.isVisible(ps);
            }
        };
        initialsList.setLayout(1);
        initialsList.setEmptyView((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.no_participants")));
        initialsList.setModelBuilder((ListModelBuilder)new AbstractListModelBuilder(){

            public ListModel makeModel(List l, PageState ps) {
                PortalSite psite = (PortalSite)((Object)portalsiteRL.get(ps));
                return new IteratorListModel(psite.getParticipantInitials());
            }
        });
        final RequestLocal firstInitialRL = new RequestLocal(){

            public Object initialValue(PageState ps) {
                PortalSite psite = (PortalSite)((Object)portalsiteRL.get(ps));
                Iterator initials = psite.getParticipantInitials();
                if (!initials.hasNext()) {
                    return null;
                }
                return initials.next();
            }
        };
        initialsList.setSelectionModel((SingleSelectionModel)new ParameterSingleSelectionModel((ParameterModel)new StringParameter("initial")){

            public Object getSelectedKey(PageState ps) {
                if (!initialsList.isVisible(ps)) {
                    return null;
                }
                Object result = super.getSelectedKey(ps);
                if (result != null) {
                    return result;
                }
                return firstInitialRL.get(ps);
            }

            public boolean isSelected(PageState ps) {
                if (!initialsList.isVisible(ps)) {
                    return false;
                }
                Object result = super.getSelectedKey(ps);
                if (result != null) {
                    return true;
                }
                return firstInitialRL.get(ps) != null;
            }
        });
        initialsList.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                PageState ps = ev.getPageState();
                ps.reset((Component)participantList);
            }
        });
        participantList.setModelBuilder((ListModelBuilder)new AbstractListModelBuilder(){

            public ListModel makeModel(List l, PageState ps) {
                PortalSite psite = (PortalSite)((Object)portalsiteRL.get(ps));
                String initial = (String)initialsList.getSelectedKey(ps);
                if (initial == null) {
                    return new ParticipantListModel(psite);
                }
                return new ParticipantListModel(psite, initial);
            }
        });
        final DynamicListWizard dlw = new DynamicListWizard("Portal Participants", (Component)participantList, (SingleSelectionModel)selectionModel, "Add a participant", (Component)new Label("")){

            public void register(Page p) {
                super.register(p);
                if (!isAdmin) {
                    p.setVisibleDefault((Component)this.getListLabel(), false);
                    p.setVisibleDefault((Component)this.getAddLink(), false);
                }
                7 theDLW = this;
                p.addRequestListener(new RequestListener(this, theDLW){
                    private final /* synthetic */ DynamicListWizard val$theDLW;
                    private final /* synthetic */ 7 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$theDLW = val$theDLW;
                    }

                    public void pageRequested(RequestEvent ev) {
                        Party party;
                        PageState ps = ev.getPageState();
                        String action = (String)ps.getValue((ParameterModel)7.access$000(this.this$0));
                        if (action == null || !action.startsWith("browse")) {
                            return;
                        }
                        BigDecimal partyID = new BigDecimal(action.substring(6));
                        ps.setValue((ParameterModel)7.access$000(this.this$0), null);
                        7.access$100(this.this$0).actionPerformed(new ActionEvent((Component)this.val$theDLW, ps));
                        OID partyOID = new OID("com.arsdigita.kernel.ACSObject", (Object)partyID);
                        try {
                            party = (Party)DomainObjectFactory.newInstance((OID)partyOID);
                        }
                        catch (DataObjectNotFoundException ex) {
                            return;
                        }
                        String initial = party instanceof User ? ((User)party).getPersonName().getFamilyName().substring(0, 1).toUpperCase() : ((Group)party).getName().substring(0, 1).toUpperCase();
                        7.access$200(this.this$0).setSelectedKey(ps, initial);
                        7.access$300(this.this$0).setSelectedKey(ps, partyID.toString());
                    }
                });
            }

            static /* synthetic */ StringParameter access$000(7 x0) {
                return x0.actionParam;
            }

            static /* synthetic */ ActionListener access$100(7 x0) {
                return x0.selectBrowse;
            }

            static /* synthetic */ List access$200(7 x0) {
                return x0.initialsList;
            }

            static /* synthetic */ List access$300(7 x0) {
                return x0.participantList;
            }
        };
        dlw.setHeader((Component)initialsList);
        RequestLocal participantRL = new RequestLocal(){

            public Object initialValue(PageState ps) {
                return selectionModel.getSelectedObject(ps);
            }
        };
        ActionListener onDelete = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                dlw.reset(ev.getPageState());
            }
        };
        ParticipantEdit participantEdit = new ParticipantEdit(portalsiteRL, participantRL, onDelete);
        ParticipantDisplay participantDisplay = new ParticipantDisplay(portalsiteRL, participantRL);
        PrivilegedComponentSelector participantEditOrDisplay = new PrivilegedComponentSelector(PrivilegeDescriptor.ADMIN, portalsiteRL, (Component)participantEdit, (Component)participantDisplay);
        dlw.setEditPane((Component)participantEditOrDisplay);
        selectionModel.addChangeListener(new ChangeListener((Component)participantEditOrDisplay){
            private final /* synthetic */ Component val$participantEditOrDisplay;
            {
                this.val$participantEditOrDisplay = val$participantEditOrDisplay;
            }

            public void stateChanged(ChangeEvent ev) {
                ev.getPageState().reset(this.val$participantEditOrDisplay);
            }
        });
        if (isAdmin) {
            dlw.setAddPane(ParticipantBrowsePane.buildAddParticipant(portalsiteRL));
        }
        return dlw;
    }

    private static FormSection buildRoleFormSection(final RequestLocal portalsiteRL, final RequestLocal participantRL) {
        FormSection form = new FormSection((Container)new ColumnPanel(1));
        Label rHeader = new Label(GlobalizationUtil.globalize("cw.workspace.ui.roles"));
        rHeader.setFontWeight("b");
        form.add((Component)rHeader);
        final CheckboxGroup roles = new CheckboxGroup("roles");
        roles.setPrintListener(new PrintListener(){

            public void prepare(PrintEvent ev) {
                CheckboxGroup tgt = (CheckboxGroup)ev.getTarget();
                PageState ps = ev.getPageState();
                PortalSite psite = (PortalSite)((Object)portalsiteRL.get(ps));
                RoleCollection roleColl = psite.getRoles();
                while (roleColl.next()) {
                    tgt.addOption(new Option(roleColl.getID().toString(), roleColl.getRoleName()));
                }
            }
        });
        form.add((Component)roles);
        form.addInitListener(new FormInitListener(){

            public void init(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                Party party = (Party)participantRL.get(ps);
                if (party == null) {
                    return;
                }
                PortalSite psite = (PortalSite)((Object)portalsiteRL.get(ps));
                RoleCollection rc = psite.getRoles();
                LinkedList<String> roleIDs = new LinkedList<String>();
                while (rc.next()) {
                    Role r = rc.getRole();
                    if (!r.hasDirectMemberOrSubgroup(party)) continue;
                    roleIDs.add(rc.getID().toString());
                }
                roles.setValue(ps, (Object)roleIDs.toArray());
            }
        });
        form.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                Object[] roleIDstrs = (Object[])roles.getValue(ps);
                HashSet<BigDecimal> roleIDs = new HashSet<BigDecimal>();
                if (roleIDstrs != null) {
                    for (int i = 0; i < roleIDstrs.length; ++i) {
                        BigDecimal id = new BigDecimal((String)roleIDstrs[i]);
                        roleIDs.add(id);
                        Role role = (Role)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.workspace.Role", (Object)id));
                        role.getPortalSite().assertPrivilege(PrivilegeDescriptor.ADMIN);
                    }
                }
                KernelExcursion ex = new KernelExcursion(this, roleIDs, ev){
                    private final /* synthetic */ HashSet val$roleIDs;
                    private final /* synthetic */ FormSectionEvent val$ev;
                    private final /* synthetic */ 14 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$roleIDs = val$roleIDs;
                        this.val$ev = val$ev;
                    }

                    protected void excurse() {
                        this.setEffectiveParty(Kernel.getSystemParty());
                        14.access$400(this.this$0, this.val$roleIDs, this.val$ev.getPageState());
                    }
                };
                ex.run();
            }

            private void doProcess(HashSet roleIDs, PageState ps) {
                Party party = (Party)participantRL.get(ps);
                RoleCollection rc = ((PortalSite)((Object)portalsiteRL.get(ps))).getRoles();
                while (rc.next()) {
                    Role role = rc.getRole();
                    if (roleIDs.contains(role.getID())) {
                        if (role.hasDirectMemberOrSubgroup(party)) continue;
                        role.addMemberOrSubgroup(party);
                        role.save();
                        continue;
                    }
                    if (!role.hasDirectMemberOrSubgroup(party)) continue;
                    role.removeMemberOrSubgroup(party);
                    role.save();
                }
            }

            static /* synthetic */ void access$400(14 x0, HashSet x1, PageState x2) {
                x0.doProcess(x1, x2);
            }
        });
        return form;
    }

    private static Component buildAddParticipant(final RequestLocal portalsiteRL) {
        final RequestLocal partiesRL = new RequestLocal();
        Form userSearch = new Form("usersearch");
        userSearch.setMethod("post");
        final Label searchRedoLabel = new Label("");
        final Label emptyLabel = new Label("");
        final Form userAdd = new Form("useradd", (Container)new BoxPanel(2));
        userAdd.setMethod("post");
        SimpleContainer result = new SimpleContainer();
        result.add((Component)userSearch);
        final ModalContainer bottomHalf = new ModalContainer();
        bottomHalf.add((Component)emptyLabel);
        bottomHalf.add((Component)searchRedoLabel);
        bottomHalf.add((Component)userAdd);
        bottomHalf.setDefaultComponent((Component)emptyLabel);
        result.add((Component)bottomHalf);
        userSearch.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.enter_first_name_last_name_andor_email_address")));
        final TextField query = new TextField("query");
        userSearch.add((Component)query);
        userSearch.add((Component)new Label(""));
        userSearch.add((Component)new Submit("Search"));
        userSearch.add((Component)new Label());
        userSearch.add((Component)new FormErrorDisplay(userSearch), 64);
        userSearch.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent e) throws FormProcessException {
                PageState ps = e.getPageState();
                PortalSite psite = (PortalSite)((Object)portalsiteRL.get(ps));
                PartyCollection parties = psite.getNonParticipants();
                parties.filter((String)query.getValue(ps));
                long count = parties.size();
                if (count == 0L) {
                    bottomHalf.setVisibleComponent(ps, (Component)searchRedoLabel);
                    searchRedoLabel.setLabel((String)GlobalizationUtil.globalize("cw.workspace.ui.no_matches_found").localize(), ps);
                } else if (count > 100L) {
                    bottomHalf.setVisibleComponent(ps, (Component)searchRedoLabel);
                    searchRedoLabel.setLabel(count + " matches found. Please enter more" + " specific search criteria.", ps);
                } else {
                    partiesRL.set(ps, (Object)parties);
                    bottomHalf.setVisibleComponent(ps, (Component)userAdd);
                }
            }
        });
        userAdd.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.select_user_or_group_to_add")));
        final RadioGroup users = new RadioGroup("users");
        users.setLayout(2);
        userAdd.add((Component)users);
        final RequestLocal addedParticipantRL = new RequestLocal(){

            public Object initialValue(PageState ps) {
                String partIDstr = (String)users.getValue(ps);
                if (partIDstr == null) {
                    return null;
                }
                OID partyOID = new OID("com.arsdigita.kernel.ACSObject", (Object)new BigDecimal(partIDstr));
                try {
                    return (Party)DomainObjectFactory.newInstance((OID)partyOID);
                }
                catch (DataObjectNotFoundException ex) {
                    return null;
                }
            }
        };
        userAdd.add((Component)new Submit("Add Participant"));
        userAdd.addInitListener(new FormInitListener(){

            public void init(FormSectionEvent e) {
                PageState ps = e.getPageState();
                PartyCollection parties = (PartyCollection)partiesRL.get(ps);
                if (parties == null) {
                    bottomHalf.setVisibleComponent(ps, (Component)emptyLabel);
                    return;
                }
                if (parties.next()) {
                    do {
                        EmailAddress email = parties.getPrimaryEmail();
                        users.addOption(new Option(parties.getID().toString(), parties.getDisplayName() + (email == null ? "" : " <" + email.getEmailAddress() + ">")), ps);
                    } while (parties.next());
                } else {
                    users.addOption(new Option("none", "No Users Found"), ps);
                }
            }
        });
        userAdd.addProcessListener(new FormProcessListener((Container)result){
            private final /* synthetic */ Container val$result;
            {
                this.val$result = val$result;
            }

            public void process(FormSectionEvent e) throws FormProcessException {
                PageState ps = e.getPageState();
                PortalSite psite = (PortalSite)((Object)portalsiteRL.get(ps));
                Party party = (Party)addedParticipantRL.get(ps);
                psite.assertPrivilege(PrivilegeDescriptor.ADMIN);
                KernelExcursion ex = new KernelExcursion(this, psite, party){
                    private final /* synthetic */ PortalSite val$psite;
                    private final /* synthetic */ Party val$party;
                    private final /* synthetic */ 19 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$psite = val$psite;
                        this.val$party = val$party;
                    }

                    protected void excurse() {
                        this.setEffectiveParty(Kernel.getSystemParty());
                        this.val$psite.addParticipant(this.val$party);
                        this.val$psite.save();
                    }
                };
                ex.run();
                ps.reset((Component)this.val$result);
                String url = null;
                try {
                    url = ps.stateAsURL();
                }
                catch (IOException ioe) {
                    throw new UncheckedWrapperException((Throwable)ioe);
                }
                throw new RedirectSignal(url, true);
            }
        });
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

