/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Resource;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.portal.Portal;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.PortalTabCollection;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;

public class PortalTab
extends Portal {
    private static final int SORT_KEY_JUMP = 10;
    private static final String DEFAULT_LAYOUT = "NW";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.workspace.WorkspaceTab";
    private boolean m_wasNew;

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public PortalTab(DataObject dataObject) {
        super(dataObject);
    }

    public static PortalTab createTab(String title, Resource parent) {
        PortalTab ptab = (PortalTab)Portal.create((String)BASE_DATA_OBJECT_TYPE, (String)title, (Resource)parent);
        ptab.setSortKey(0);
        ptab.setLayout(DEFAULT_LAYOUT);
        return ptab;
    }

    public static PortalTab createTab(String title) {
        PortalTab ptab = (PortalTab)Portal.create((String)BASE_DATA_OBJECT_TYPE, (String)title, null);
        ptab.setSortKey(0);
        ptab.setLayout(DEFAULT_LAYOUT);
        return ptab;
    }

    public static PortalTab retrieveTab(BigDecimal prtlTabID) {
        Assert.assertNotNull((Object)prtlTabID);
        return PortalTab.retrieveTab(new OID(BASE_DATA_OBJECT_TYPE, (Object)prtlTabID));
    }

    public static PortalTab retrieveTab(DataObject dataObject) {
        Assert.assertNotNull((Object)dataObject);
        DomainObject dobj = DomainObjectFactory.newInstance((DataObject)dataObject);
        return (PortalTab)dobj;
    }

    public static PortalTab retrieveTab(OID oid) {
        Assert.assertNotNull((Object)oid);
        DataObject dataObject = SessionManager.getSession().retrieve(oid);
        return PortalTab.retrieveTab(dataObject);
    }

    public static boolean doesTabExist(BigDecimal bd) {
        OID oid = new OID(BASE_DATA_OBJECT_TYPE, (Object)bd);
        DataObject dataObject = SessionManager.getSession().retrieve(oid);
        return dataObject != null;
    }

    public static PortalTabCollection retrieveAllTabs() {
        DataCollection dataCollection = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        PortalTabCollection tabCollection = new PortalTabCollection(dataCollection);
        return tabCollection;
    }

    public static PortalTabCollection getTabsForPortalSite(PortalSite p) {
        DataCollection dataCollection = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        PortalTabCollection tabCollection = new PortalTabCollection(dataCollection);
        return tabCollection;
    }

    public String getTitle() {
        String title = (String)this.get("title");
        Assert.assertNotNull((Object)title);
        return title;
    }

    public void setTitle(String title) {
        Assert.assertNotNull((Object)title);
        this.set("title", title);
    }

    public void setPortalSite(PortalSite psite) {
        this.setAssociation("workspace", (DomainObject)psite);
    }

    public PortalSite getPortalSite() {
        DataObject dataObject = (DataObject)this.get("workspace");
        Assert.assertNotNull((Object)dataObject, (String)"dataObject");
        return new PortalSite(dataObject);
    }

    public int getSortKey() {
        return (Integer)this.get("sortKey");
    }

    public void setSortKey(int sortKey) {
        this.set("sortKey", new Integer(sortKey));
    }

    public String getLayout() {
        return (String)this.get("tab_layout");
    }

    public void setLayout(String layout) {
        this.set("tab_layout", layout);
    }

    protected void beforeSave() {
        this.m_wasNew = this.isNew();
        super.beforeSave();
    }

    public void afterSave() {
        super.afterSave();
        if (this.m_wasNew) {
            PortalSite psite = (PortalSite)DomainObjectFactory.newInstance((DataObject)((DataObject)this.get("workspace")));
            PermissionService.setContext((ACSObject)this, (ACSObject)psite);
        }
    }
}

