/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.DimensionalNavbar;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.portalserver.ApplicationPage;
import com.arsdigita.portalserver.LoggedInLinkWrapper;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.PortalSiteCollection;
import com.arsdigita.portalserver.Theme;
import com.arsdigita.portalserver.ThemeCollection;
import com.arsdigita.portalserver.personal.PersonalPortal;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import com.arsdigita.util.Assert;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Document;
import com.arsdigita.xml.Element;
import javax.servlet.http.HttpServletRequest;

public class PortalPage
extends ApplicationPage {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/PortalPage.java#10 $$Author: jparsons $$DateTime: 2003/11/13 12:59:02 $";

    protected PortalPage() {
        this.addRequestListener(new RequestListener(){

            public void pageRequested(RequestEvent e) {
                PageState s = e.getPageState();
                PortalSite psite = PortalSite.getCurrentPortalSite(s.getRequest());
                if (psite == null) {
                    return;
                }
                if (!psite.isPersonalizable()) {
                    return;
                }
                User user = Web.getContext().getUser();
                if (user == null) {
                    return;
                }
                PortalSiteCollection psc = psite.getAllChildPortalSites();
                PortalSite p = null;
                boolean found = false;
                while (psc.next()) {
                    p = psc.getPortalSite();
                    String path = p.getPath();
                    String fragment = path.substring(path.lastIndexOf("/"));
                    if (fragment.compareTo("/U-" + user.getID().toString()) != 0) continue;
                    found = true;
                    break;
                }
                if (found) {
                    throw new RedirectSignal(URL.there((HttpServletRequest)s.getRequest(), (String)p.getPath()), false);
                }
            }
        });
    }

    protected void buildContextBar() {
        DimensionalNavbar navbar = new DimensionalNavbar();
        navbar.setClassAttr("portalNavbar");
        navbar.add((Component)new LoggedInLinkWrapper(new PersonalPortalLinkPrinter()));
        Link current = new Link(new CurrentPortalLinkPrinter()){

            public boolean isVisible(PageState state) {
                PortalSite psite = PortalSite.getCurrentPortalSite(state.getRequest());
                return !(psite instanceof PersonalPortal);
            }
        };
        navbar.add((Component)current);
        navbar.add((Component)new Link((PrintListener)new ApplicationPage.CurrentApplicationLinkPrinter()));
        this.getHeader().add((Component)navbar);
    }

    protected void buildGlobal(Container global) {
        super.buildGlobal(global);
        ActionLink personalizable = new ActionLink("Personalize This Portal!"){

            public boolean isVisible(PageState s) {
                PortalSite psite = PortalSite.getCurrentPortalSite(s.getRequest());
                if (psite == null) {
                    return false;
                }
                if (!psite.isPersonalizable()) {
                    return false;
                }
                String url = Web.getContext().getRequestURL().getRequestURI();
                if (url.endsWith("admin/")) {
                    return false;
                }
                User user = Web.getContext().getUser();
                if (user == null) {
                    return false;
                }
                PortalSiteCollection psc = psite.getAllChildPortalSites();
                while (psc.next()) {
                    PortalSite p = psc.getPortalSite();
                    String path = p.getPath();
                    String fragment = path.substring(path.lastIndexOf("/"));
                    if (fragment.compareTo("/U-" + user.getID().toString()) != 0) continue;
                    return false;
                }
                return true;
            }
        };
        personalizable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState s = e.getPageState();
                PortalSite psite = PortalSite.getCurrentPortalSite(s.getRequest());
                User user = Web.getContext().getUser();
                PortalSite newsite = PortalSite.createSubPortal(psite, user);
                throw new RedirectSignal(URL.there((HttpServletRequest)s.getRequest(), (String)newsite.getPath()), true);
            }
        });
        personalizable.setIdAttr("personalize_link");
        global.add((Component)personalizable);
    }

    public void generateXML(PageState state, Document parent) {
        super.generateXML(state, parent);
        this.addStyleBlock(state, parent);
    }

    public void addStyleBlock(PageState state, Document parent) {
        Theme theme = PortalSite.getCurrentPortalSite(state.getRequest()).getTheme();
        if (theme == null) {
            ThemeCollection themes = Theme.retrieveAllThemes();
            while (themes.next() && !(theme = themes.getTheme()).getName().equals("Red Hat")) {
            }
            themes.close();
        }
        if (theme == null) {
            return;
        }
        StringBuffer buffer = theme.buildStyleBlock();
        Element rootElement = parent.getRootElement();
        Element styleBlock = rootElement.newChildElement("portalserver:styleblock", "http://www.redhat.com/portalserver/1.0");
        styleBlock.setCDATASection(buffer.toString());
    }

    protected class CurrentPortalLabelPrinter
    implements PrintListener {
        public void prepare(PrintEvent e) {
            Label label = (Label)e.getTarget();
            PageState pageState = e.getPageState();
            PortalSite psite = PortalSite.getCurrentPortalSite(pageState.getRequest());
            Assert.assertNotNull((Object)((Object)psite), (String)"PortalSite psite");
            label.setLabel(psite.getTitle());
        }
    }

    protected class CurrentPortalLinkPrinter
    implements PrintListener {
        public void prepare(PrintEvent e) {
            Link link = (Link)e.getTarget();
            PageState state = e.getPageState();
            PortalSite psite = PortalSite.getCurrentPortalSite(state.getRequest());
            if (psite == null) {
                link.setChild((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ecm_administration")));
                link.setTarget("/portal-admin/");
            } else {
                link.setChild((Component)new Label(psite.getTitle()));
                link.setTarget(psite.getPrimaryURL());
            }
        }
    }

    protected class PersonalPortalLinkPrinter
    implements PrintListener {
        public void prepare(PrintEvent e) {
            Link link = (Link)e.getTarget();
            Party party = Kernel.getContext().getParty();
            if (party != null) {
                link.setChild((Component)new Label(GlobalizationUtil.globalize("cw.workspace.personal_workspace")));
                link.setTarget("/personal-portal/" + party.getID() + "/");
            }
        }
    }
}

