/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.kernel.BaseInitializer;
import com.arsdigita.kernel.NoValidURLException;
import com.arsdigita.kernel.PackageType;
import com.arsdigita.kernel.ResourceSetup;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.kernel.Stylesheet;
import com.arsdigita.kernel.URLFinder;
import com.arsdigita.kernel.URLService;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.portal.AgentPortlet;
import com.arsdigita.portal.PortletSetup;
import com.arsdigita.portal.apportlet.AppPortletSetup;
import com.arsdigita.portalserver.ApplicationDirectoryPortlet;
import com.arsdigita.portalserver.CWURLFinder;
import com.arsdigita.portalserver.PortalNavigatorPortlet;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.PortalSummaryPortlet;
import com.arsdigita.portalserver.PortalTab;
import com.arsdigita.portalserver.Role;
import com.arsdigita.portalserver.SubPortalTab;
import com.arsdigita.portalserver.Theme;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationSetup;
import com.arsdigita.web.ApplicationType;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public class OldInitializer
extends BaseInitializer {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/OldInitializer.java#3 $$Author: scott $$DateTime: 2004/01/20 11:45:10 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$portalserver$Initializer == null ? (class$com$arsdigita$portalserver$Initializer = OldInitializer.class$("com.arsdigita.portalserver.Initializer")) : class$com$arsdigita$portalserver$Initializer));
    private Configuration m_conf = new Configuration();
    static /* synthetic */ Class class$com$arsdigita$portalserver$Initializer;
    static /* synthetic */ Class class$java$lang$String;

    public OldInitializer() throws InitializationException {
        this.m_conf.initParameter("urlPathPrefix", "XXX", class$java$lang$String == null ? (class$java$lang$String = OldInitializer.class$("java.lang.String")) : class$java$lang$String);
    }

    public Configuration getConfiguration() {
        return this.m_conf;
    }

    public final void doStartup() {
        s_log.info((Object)"Initializing Portal...");
        TransactionContext txn = SessionManager.getSession().getTransactionContext();
        txn.beginTxn();
        PackageType portalPackageType = this.setupPortalPackageType();
        ApplicationType portalAppType = this.setupPortalApplication(portalPackageType);
        this.setupPortalNavigatorPortlet();
        this.setupApplicationDirectoryPortlet();
        this.setupPortalSummaryPortlet();
        this.setupAgentPortlet();
        this.setupAdminPortal();
        ResourceType rtype = this.setupResource();
        ResourceType restype = this.setupSubPortal();
        txn.commitTxn();
        URLFinder forumFinder = new URLFinder(){

            public String find(OID oid) throws NoValidURLException {
                Application app = Application.retrieveApplication((OID)oid);
                return app.getPrimaryURL();
            }

            public String find(OID oid, String context) throws NoValidURLException {
                return this.find(oid);
            }
        };
        URLService.registerFinder((String)"com.arsdigita.web.Application", (URLFinder)forumFinder);
        CWURLFinder finder = new CWURLFinder("admin");
        URLService.registerFinder((String)"com.arsdigita.workspace.Workspace", (URLFinder)finder);
        s_log.info((Object)"Done initializing PortalSite.");
    }

    private PackageType setupPortalPackageType() {
        try {
            return PackageType.findByKey((String)"portalsite");
        }
        catch (DataObjectNotFoundException nfe) {
            s_log.info((Object)"PackageType 'portalsite' is not installed.  Installing now...");
            Stylesheet stylesheet = Stylesheet.createStylesheet((String)"/packages/portalserver/xsl/portalserver.xsl");
            PackageType packageType = PackageType.create((String)"portalsite", (String)"PortalSite", (String)"PortalSites", (String)"http://arsdigita.com/portalsite");
            packageType.addStylesheet(stylesheet);
            packageType.setDispatcherClass("com.arsdigita.portalserver.ui.PortalDispatcher");
            packageType.save();
            this.buildDefaultThemes();
            return packageType;
        }
    }

    private ApplicationType setupPortalApplication(PackageType packageType) {
        ApplicationSetup setup = new ApplicationSetup((Category)s_log);
        setup.setApplicationObjectType("com.arsdigita.workspace.Workspace");
        setup.setPackageType(packageType);
        setup.setTitle("Portal");
        setup.setDescription("A Portal Site is a center for content aggregation.  It usuallyhas its own set of applications, such as a discussion forumand content items, as well as a list of participants.");
        setup.setPortalApplication(false);
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            protected DomainObject doNewInstance(DataObject dataObject) {
                return new PortalSite(dataObject);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.workspace.Role", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new Role(dataObject);
            }
        });
        return setup.run();
    }

    private void setupPortalNavigatorPortlet() {
        AppPortletSetup setup = new AppPortletSetup((Category)s_log);
        setup.setPortletObjectType("com.arsdigita.workspace.WorkspaceNavigatorPortlet");
        setup.setTitle("Portal Navigator");
        setup.setDescription("Provides links to portal associated with the current portal.");
        setup.setProfile("narrow");
        setup.setPortalApplication(true);
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new PortalNavigatorPortlet(dataObject);
            }
        });
        setup.run();
    }

    private void setupApplicationDirectoryPortlet() {
        AppPortletSetup setup = new AppPortletSetup((Category)s_log);
        setup.setPortletObjectType("com.arsdigita.workspace.ApplicationDirectoryPortlet");
        setup.setTitle("Application Directory");
        setup.setDescription("Provides links to the workspace's applications.");
        setup.setProfile("narrow");
        setup.setPortalApplication(true);
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new ApplicationDirectoryPortlet(dataObject);
            }
        });
        setup.run();
    }

    private void setupPortalSummaryPortlet() {
        AppPortletSetup setup = new AppPortletSetup((Category)s_log);
        setup.setPortletObjectType("com.arsdigita.workspace.WorkspaceSummaryPortlet");
        setup.setTitle("Portal Summary");
        setup.setProfile("narrow");
        setup.setPortalApplication(true);
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new PortalSummaryPortlet(dataObject);
            }
        });
        setup.run();
    }

    private void setupAgentPortlet() {
        PortletSetup setup = new PortletSetup((Category)s_log);
        setup.setPortletObjectType("com.arsdigita.portal.AgentPortlet");
        setup.setTitle("Agent");
        setup.setDescription("Acts as agent or proxy for another portlet.");
        setup.setProfile("wide");
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new AgentPortlet(dataObject);
            }
        });
        setup.run();
    }

    private void setupAdminPortal() {
        try {
            SiteNode sn = SiteNode.getSiteNode((String)"/administration", (boolean)false);
            if (!"administration".equals(sn.getName())) {
                PortalSite ps = PortalSite.createPortalSite("administration", "Administration", null);
                ps.setMission("Administration Portal");
                ps.save();
            }
        }
        catch (DataObjectNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private ResourceType setupResource() {
        ResourceSetup setup = new ResourceSetup(s_log);
        setup.setTitle("PortalTab");
        setup.setResourceObjectType("com.arsdigita.workspace.WorkspaceTab");
        setup.setDescription("A Portal Tab!");
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new PortalTab(dataObject);
            }
        });
        return setup.run();
    }

    private ResourceType setupSubPortal() {
        ResourceSetup setup = new ResourceSetup(s_log);
        setup.setTitle("SubPortalTab");
        setup.setResourceObjectType("com.arsdigita.workspace.SubWorkspaceTab");
        setup.setDescription("A SubPortal Tab!");
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new SubPortalTab(dataObject);
            }
        });
        return setup.run();
    }

    private void buildDefaultThemes() {
        Theme theme0 = new Theme("Red Hat");
        theme0.setDescription("A cool corporate theme");
        theme0.setContextBarColor("#E1E1E1");
        theme0.setContextBarTextColor("#3F3F3F");
        theme0.setActiveTabColor("#a21e1e");
        theme0.setInactiveTabColor("#dddddd");
        theme0.setInactiveTabTextColor("#555555");
        theme0.setActiveTabTextColor("#ffffff");
        theme0.setTopRuleColor("#a21e1e");
        theme0.setBottomRuleColor("#a21e1e");
        theme0.setPortletHeaderColor("#a21e1e");
        theme0.setPortletIconColor("#a21e1e");
        theme0.setPortletHeaderTextColor("#ffffff");
        theme0.setPageBGColor("#ffffff");
        theme0.setBodyTextColor("#000000");
        theme0.setNarrowBGColor("#dddddd");
        theme0.save();
        Theme theme2 = new Theme("Bright Day");
        theme2.setDescription("A sunny, cloudless sky");
        theme2.setContextBarColor("#003366");
        theme2.setContextBarTextColor("#FFFFFF");
        theme2.setActiveTabColor("#93bee2");
        theme2.setInactiveTabColor("#d8e8f5");
        theme2.setInactiveTabTextColor("#000000");
        theme2.setActiveTabTextColor("#000000");
        theme2.setTopRuleColor("#93bee2");
        theme2.setBottomRuleColor("#93bee2");
        theme2.setPortletHeaderColor("#cccccc");
        theme2.setPortletIconColor("#cccccc");
        theme2.setPortletHeaderTextColor("#000000");
        theme2.setPageBGColor("#ffffff");
        theme2.setPageBGImage("");
        theme2.setNarrowBGColor("#dddddd");
        theme2.setBodyTextColor("#000000");
        theme2.save();
        Theme theme3 = new Theme("Harvest");
        theme3.setDescription("High Heat");
        theme3.setContextBarColor("#ff9966");
        theme3.setContextBarTextColor("#ffffff");
        theme3.setActiveTabColor("#ff9966");
        theme3.setInactiveTabColor("#ffcc99");
        theme3.setInactiveTabTextColor("#000000");
        theme3.setActiveTabTextColor("#000000");
        theme3.setTopRuleColor("#ff9966");
        theme3.setBottomRuleColor("#ff9966");
        theme3.setPortletHeaderColor("#ff9966");
        theme3.setPortletIconColor("#ff9966");
        theme3.setPortletHeaderTextColor("#000000");
        theme3.setPageBGColor("#ffffff");
        theme3.setPageBGImage("");
        theme3.setNarrowBGColor("#ffffcc");
        theme3.setBodyTextColor("#000000");
        theme3.save();
        Theme theme4 = new Theme("Desert");
        theme4.setDescription("High Heat");
        theme4.setContextBarColor("#cccc99");
        theme4.setContextBarTextColor("#FFFFFF");
        theme4.setActiveTabColor("#cccc99");
        theme4.setInactiveTabColor("#ededca");
        theme4.setInactiveTabTextColor("#000000");
        theme4.setActiveTabTextColor("#000000");
        theme4.setTopRuleColor("#cccc99");
        theme4.setBottomRuleColor("#cccc99");
        theme4.setPortletHeaderColor("#cccc99");
        theme4.setPortletIconColor("#cccc99");
        theme4.setPortletHeaderTextColor("#000000");
        theme4.setPageBGColor("#ffffff");
        theme4.setPageBGImage("");
        theme4.setNarrowBGColor("#ffffcc");
        theme4.setBodyTextColor("#000000");
        theme4.save();
        Theme theme5 = new Theme("Stars and Bars");
        theme5.setDescription("Patriotic");
        theme5.setContextBarColor("#cc0000");
        theme5.setContextBarTextColor("#FFFFFF");
        theme5.setActiveTabColor("#cc0000");
        theme5.setInactiveTabColor("#ffffff");
        theme5.setInactiveTabTextColor("#000000");
        theme5.setActiveTabTextColor("#ffffff");
        theme5.setTopRuleColor("#cc0000");
        theme5.setBottomRuleColor("#cc0000");
        theme5.setPortletHeaderColor("#cc0000");
        theme5.setPortletIconColor("#cc0000");
        theme5.setPortletHeaderTextColor("#ffffff");
        theme5.setPageBGColor("#ffffff");
        theme5.setPageBGImage("/assets/cw/backgrounds/stars.gif");
        theme5.setNarrowBGColor("#eeeeee");
        theme5.setBodyTextColor("#000000");
        theme5.save();
    }

    public final void doShutdown() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

