/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.populate.portalserver;

import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.kernel.BaseInitializer;
import com.arsdigita.kernel.UserCollection;
import com.arsdigita.populate.PopulateUsers;
import com.arsdigita.populate.apps.PopulateApp;
import com.arsdigita.populate.apps.PopulateAppPair;
import com.arsdigita.populate.apps.PopulateAppPairCollection;
import com.arsdigita.populate.portalserver.PopulatePortalSites;
import com.arsdigita.populate.portlets.PopulatePortlet;
import com.arsdigita.populate.portlets.PopulatePortletCollection;
import com.arsdigita.util.Assert;
import java.util.List;
import org.apache.log4j.Logger;

public class Initializer
extends BaseInitializer {
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$populate$portalserver$Initializer == null ? (class$com$arsdigita$populate$portalserver$Initializer = Initializer.class$("com.arsdigita.populate.portalserver.Initializer")) : class$com$arsdigita$populate$portalserver$Initializer).getName());
    private Configuration m_conf = new Configuration();
    static /* synthetic */ Class class$com$arsdigita$populate$portalserver$Initializer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$util$List;

    public Configuration getConfiguration() {
        this.m_conf.initParameter("baseStringSeed", "The base string seed to use for generating String names.", class$java$lang$String == null ? (class$java$lang$String = Initializer.class$("java.lang.String")) : class$java$lang$String, null);
        this.m_conf.initParameter("numUsers", "number of users to create", class$java$lang$Integer == null ? (class$java$lang$Integer = Initializer.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.m_conf.initParameter("numPortalSiteLevels", "number of levels/depth to nest portal sites", class$java$lang$Integer == null ? (class$java$lang$Integer = Initializer.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.m_conf.initParameter("numPortalSitesPerLevel", "number of portal sites to create for each level", class$java$lang$Integer == null ? (class$java$lang$Integer = Initializer.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.m_conf.initParameter("populateAppPairs", "A list pair, consisting of the PopulateApp class with which to populate andthe arguments for that class", class$java$util$List == null ? (class$java$util$List = Initializer.class$("java.util.List")) : class$java$util$List);
        this.m_conf.initParameter("populatePortlets", "A list of PopulatePortlet classes", class$java$util$List == null ? (class$java$util$List = Initializer.class$("java.util.List")) : class$java$util$List);
        return this.m_conf;
    }

    protected void doStartup() {
        String sBaseStringSeed = (String)this.m_conf.getParameter("baseStringSeed");
        int iUsers = (Integer)this.m_conf.getParameter("numUsers");
        int iPortalSiteLevels = (Integer)this.m_conf.getParameter("numPortalSiteLevels");
        int iPortalSitesPerLevel = (Integer)this.m_conf.getParameter("numPortalSitesPerLevel");
        List popAppsList = (List)this.m_conf.getParameter("populateAppPairs");
        List popPortletsList = (List)this.m_conf.getParameter("populatePortlets");
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Using BaseStringSeed " + sBaseStringSeed));
        }
        PopulateAppPairCollection popApps = this.initPopApps(popAppsList);
        PopulatePortletCollection popPortlets = this.initPopPortlets(popPortletsList);
        s_log.info((Object)("Begin populating " + iUsers + " users"));
        PopulateUsers popUsers = new PopulateUsers();
        popUsers.setBaseStringSeed(sBaseStringSeed);
        popUsers.populate(iUsers);
        UserCollection users = popUsers.getPopulatedUsers();
        s_log.info((Object)("End populating " + iUsers + " users"));
        s_log.info((Object)"Begin populating portal server");
        PopulatePortalSites popPortals = new PopulatePortalSites(popApps, popPortlets);
        popPortals.setBaseStringSeed(sBaseStringSeed);
        popPortals.populate(iPortalSiteLevels, iPortalSitesPerLevel, null, users);
        s_log.info((Object)"End populating portal server");
    }

    private PopulateAppPairCollection initPopApps(List popAppsList) {
        PopulateAppPairCollection popAppsColl = new PopulateAppPairCollection();
        int iSize = popAppsList.size();
        for (int i = 0; i < iSize; ++i) {
            PopulateApp popApp;
            List popAppParam = (List)popAppsList.get(i);
            Assert.assertTrue((popAppParam.size() == 2 ? 1 : 0) != 0);
            String sPopApp = (String)popAppParam.get(0);
            s_log.debug((Object)("PopulateApp is " + sPopApp));
            try {
                popApp = (PopulateApp)Class.forName(sPopApp).newInstance();
            }
            catch (Exception e) {
                throw new InitializationException(e.getMessage());
            }
            List args = (List)popAppParam.get(1);
            s_log.debug((Object)("args are" + args));
            PopulateAppPair popAppPair = new PopulateAppPair(popApp, args);
            popAppsColl.addPopulateApp(popAppPair);
        }
        return popAppsColl;
    }

    private PopulatePortletCollection initPopPortlets(List popPortletsList) {
        PopulatePortletCollection popPortletsColl = new PopulatePortletCollection();
        int iSize = popPortletsList.size();
        for (int i = 0; i < iSize; ++i) {
            PopulatePortlet popPortlet;
            String sPopPortlet = (String)popPortletsList.get(i);
            s_log.debug((Object)("PopulatePortlet is " + sPopPortlet));
            try {
                popPortlet = (PopulatePortlet)Class.forName(sPopPortlet).newInstance();
            }
            catch (Exception e) {
                throw new InitializationException(e.getMessage());
            }
            popPortletsColl.addPopulatePortlet(popPortlet);
        }
        return popPortletsColl;
    }

    protected void doShutdown() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

