/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.glossary.ui;

import com.arsdigita.glossary.GlossaryWord;

import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.SimpleContainer;

/**
 * Bebop component which represents a single word/definition in
 * a glossary
 *
 * @author Kevin Scaldeferri (kevin@arsdigita.com)
 * @version $Version$
 */
public class WordView extends SimpleContainer {

    public WordView(GlossaryWord gw) {
        this(new Label(gw.getWord()),
             new Label(gw.getDefinition().getHTMLText()));
    }

    public WordView(Label word, Label defn) {
        super("glossary:word", GlossaryHelper.GLOSSARY_XML_NS);

        word.setClassAttr("word");
        add(word);

        defn.setClassAttr("definition");
        defn.setOutputEscaping(false);
        add(defn);
    }
}
