/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.glossary.ui;

import com.arsdigita.glossary.GlossaryWord;
import com.arsdigita.glossary.WordCollection;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.AbstractListModelBuilder;
import com.arsdigita.bebop.list.ListCellRenderer;


class WordList extends List {

    public WordList(final String start) {
        super();
        setClassAttr("definition");
        setModelBuilder(new AbstractListModelBuilder() {
                public ListModel makeModel(List l, PageState state) {
                    return new WordListModel(start, state);
                }
            });
        setCellRenderer(new WordCellRenderer());
    }

    private class WordListModel implements ListModel {

        WordCollection m_words = null;

        public WordListModel(String start, PageState state) {
            m_words = GlossaryHelper.getGlossary(state.getRequest())
                .getWordList(start);
        }

        public Object getElement() {
            return m_words.getWord();
        }

        public String getKey() {
            return m_words.getWord().getID().toString();
        }

        public boolean next() {
            return m_words.next();
        }
    }


    private class WordCellRenderer implements ListCellRenderer {
        public Component getComponent(List list, PageState state,
                                      Object value, String key,
                                      int index, boolean isSelected) {
            return new WordView((GlossaryWord) value);
        }
    }
}
