/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.glossary.ui;


import com.arsdigita.glossary.util.GlobalizationUtil; 

import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.bebop.PageState;
import com.arsdigita.web.Application;
import com.arsdigita.xml.Element;

public class GlossaryLettersPortletRenderer extends AbstractPortletRenderer {
    public static final String versionId = "$Id: //apps/glossary/dev/src/com/arsdigita/glossary/ui/GlossaryLettersPortletRenderer.java#2 $ by $Author: dennis $, $DateTime: 2003/08/15 13:46:34 $";

    private GlossaryLettersPortlet m_portlet;

    private static final int ASCII_A = 65;
    private static final int ASCII_Z = 90;

    public GlossaryLettersPortletRenderer(GlossaryLettersPortlet
                                          glossaryLettersPortlet) {
        m_portlet = glossaryLettersPortlet;
    }

    protected void generateBodyXML(PageState pageState,
                                   Element parentElement) {
        Application application = m_portlet.getParentApplication();

        GridPanel outerPanel = new GridPanel(1);
        GridPanel panel = new GridPanel(27);

        outerPanel.add(panel);

        String url = application.getPrimaryURL();

        for (int x = ASCII_A ; x <= ASCII_Z ; x++) {
            Link link = new Link("" + (char) x, url);
            link.setVar("starts_with", Integer.toString(x));
            panel.add(link);
        }

        Link link = new Link((String) GlobalizationUtil.globalize("cw.glossary.ui.all").localize(),  url);
        link.setVar("starts_with", Integer.toString(ASCII_Z + 1));
        panel.add(link);

        outerPanel.generateXML(pageState, parentElement);
    }
}
