/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.glossary;

import com.arsdigita.glossary.ui.GlossaryPage;
import com.arsdigita.glossary.ui.GlossaryAdminView;
import com.arsdigita.glossary.ui.GlossaryUserView;

import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.BebopMapDispatcher;


/**
 * Glossary dispatcher.
 *
 * @author Kevin Scaldeferri (kevin@arsdigita.com)
 * @version $Revision: #2 $ $Date: 2003/08/15 $
 * @since ACS 4.6.5
 */


public class GlossaryDispatcher extends BebopMapDispatcher {


    public static final String versionId =  "$Id: //apps/glossary/dev/src/com/arsdigita/glossary/GlossaryDispatcher.java#2 $ by $Author: dennis $ by $DateTime: 2003/08/15 13:46:34 $";

    public GlossaryDispatcher() {
        Page index = buildIndexPage();
        Page admin = buildAdminIndexPage();

        addPage("", index);
        addPage("index.jsp", index);
        addPage("admin/", admin);
        addPage("admin/index.jsp", admin);
    }

    private GlossaryPage buildIndexPage() {
        Glossary glossary;

        GlossaryPage p = new GlossaryPage("user");
        p.add(new GlossaryUserView());
        p.lock();

        return p;

    }

    /**
     * Methods to create Bebop pages for other URLS go here.
     */

    private GlossaryPage buildAdminIndexPage() {

        GlossaryPage p = new GlossaryPage("admin");
        p.add(new GlossaryAdminView());
        p.lock();
        return p;

    }
}
